# modified from the python library faker:
# https://github.com/joke2k/faker/blob/master/faker/providers/phone_number

phone_number_formats_en_us <- c(
  "+##(#)##########",
  "+##(#)##########",
  "0##########",
  "0##########",
  "###-###-####",
  "(###)###-####",
  "1-###-###-####",
  "###.###.####",
  "###-###-####",
  "(###)###-####",
  "1-###-###-####",
  "###.###.####",
  "###-###-####x###",
  "(###)###-####x###",
  "1-###-###-####x###",
  "###.###.####x###",
  "###-###-####x####",
  "(###)###-####x####",
  "1-###-###-####x####",
  "###.###.####x####",
  "###-###-####x#####",
  "(###)###-####x#####",
  "1-###-###-####x#####",
  "###.###.####x#####"
)

phone_number_formats_en_au <- c(
  # Local calls
  "#### ####",
  "####-####",
  "####.####", # domain registrars apparently use this
  "########",
  # National dialing
  "0{{area_code}} #### ####",
  "0{{area_code}}-####-####",
  "0{{area_code}}.####.####",
  "0{{area_code}}########",
  # Optional parenthesis
  "(0{{area_code}}) #### ####",
  "(0{{area_code}})-####-####",
  "(0{{area_code}}).####.####",
  "(0{{area_code}})########",
  # International drops the 0
  "+61 {{area_code}} #### ####",
  "+61-{{area_code}}-####-####",
  "+61.{{area_code}}.####.####",
  "+61{{area_code}}########",
  # 04 Mobile telephones (Australia-wide) mostly commonly written 4 - 3 -
  # 3 instead of 2 - 4 - 4
  "04## ### ###",
  "04##-###-###",
  "04##.###.###",
  "+61 4## ### ###",
  "+61-4##-###-###",
  "+61.4##.###.###"
)

area_codes_formats_en_au <- c(
  "2",
  "3",
  "7",
  "8"
)

phone_number_formats_es_es <- c(
  "+34 ### ### ###",
  "+34 #########",
  "+34 ### ## ## ##",
  "+34### ### ###",
  "+34#########",
  "+34### ## ## ##"
)

phone_number_formats_es_mx <- c(
  "+##(#)##########",
  "+##(#)##########",
  "0##########",
  "0##########",
  "###-###-####",
  "(###)###-####",
  "1-###-###-####",
  "###.###.####",
  "###-###-####",
  "(###)###-####",
  "1-###-###-####",
  "###.###.####",
  "###-###-####x###",
  "(###)###-####x###",
  "1-###-###-####x###",
  "###.###.####x###",
  "###-###-####x####",
  "(###)###-####x####",
  "1-###-###-####x####",
  "###.###.####x####",
  "###-###-####x#####",
  "(###)###-####x#####",
  "1-###-###-####x#####",
  "###.###.####x#####"
)

area_codes_formats_es_pe <- c(
  # 1',  # Lima / Callao -- special case, phone numbers here have 7 digits
  "41", # Amazonas
  "43", # Ancash
  "83", # Apurímac
  "54", # Arequipa
  "66", # Ayacucho
  "76", # Cajamarca
  "84", # Cusco
  "67", # Huancavelica
  "62", # Huánuco
  "56", # Ica
  "64", # Junín
  "44", # La Libertad
  "74", # Lambayeque
  "65", # Loreto
  "82", # Madre de Dios
  "53", # Moquegua
  "63", # Pasco
  "73", # Piura
  "51", # Puno
  "42", # San Martín
  "52", # Tacna
  "72", # Tumbes
  "61" # Ucayali
)

phone_number_formats_es_pe <- c(
  # landline in Lima / Callao
  "+51-1-#######",
  "+51-1-###-####",
  "1-#######",
  "1-###-####",
  "#######",
  "###-####",
  # national long distance prefix, also for cellphone to landline
  "0-1-#######",
  "0-1-###-####",
  "01-#######",
  "01-###-####",
  # landline in the rest of the country
  "+51-{{area_code}}-######",
  "+51-{{area_code}}-###-###",
  "{{area_code}}-######",
  "{{area_code}}-###-###",
  # national long distance prefix, also for cellphone to landline
  "0-{{area_code}}-######",
  "0-{{area_code}}-###-###",
  "0{{area_code}}-######",
  "0{{area_code}}-###-###",
  # cellphone numbers always start with '9'
  "+51-9########",
  "+51-9##-###-###",
  "9########",
  "9##-###-###"
)


phone_number_formats_en_gb <- c(
  "+44(0)##########",
  "+44(0)#### ######",
  "+44(0)#########",
  "+44(0)#### #####",
  "0##########",
  "0#########",
  "0#### ######",
  "0#### #####",
  "(0####) ######",
  "(0####) #####"
)

phone_number_formats_en_ca <- c(
  "%##-###-####",
  "%##.###.####",
  "%## ### ####",
  "(%##) ###-####",
  "1-%##-###-####",
  "1 (%##) ###-####",
  "+1 (%##) ###-####",
  "%##-###-#### x###",
  "(%##) ###-#### x###"
)


phone_number_formats_el_gr <- c(
  "69########",
  "69## ######",
  "69## ### ###",
  "210#######",
  "210 #######",
  "210 ### ####",
  "2##0######",
  "2##0 ######",
  "2##0 ### ###",
  "2###0#####",
  "2###0 ## ###",
  "(+30) 69## ######",
  "+30 69## ######",
  "+3069########",
  "(+30) 2### ######",
  "+30 2### ######",
  "+302#########"
)

phone_number_formats_en_nz <- c(
  # Local calls
  "%## ####",
  "%##-####",
  "%######",
  # National & Mobile dialing
  "0{{area_code}} %## ####",
  "0{{area_code}} %##-####",
  "0{{area_code}}-%##-####",
  "0{{area_code}} %######",
  # Optional parenthesis
  "(0{{area_code}}) %## ####",
  "(0{{area_code}}) %##-####",
  "(0{{area_code}}) %######",
  # International drops the 0
  "+64 {{area_code}} %## ####",
  "+64 {{area_code}} %##-####",
  "+64 {{area_code}} %######",
  "+64-{{area_code}}-%##-####",
  "+64{{area_code}}%######"
)

area_codes_formats_en_nz <- c(
  # Mobiles
  "20",
  "21",
  "22",
  "27",
  "29",
  "3", # South Island
  "4", # Wellington
  "6", # Lower North Island
  "7", # Central North Island
  "9" # Auckland
)

phone_number_formats_da_dk <- c(
  "+45########",
  "+45 ## ## ## ##",
  "########",
  "## ######",
  "0045########",
  "(+45)########",
  "(45) ########"
)

phone_number_formats_dk_dk <- c(
  "+45(0)##########",
  "+45(0)#### ######",
  "+45 (0) #### ######",
  "+45(0) #########",
  "+45(0)#### #####",
  "0##########",
  "0#########",
  "0#### ######",
  "0#### #####",
  "(0####) ######",
  "(0####) #####"
)

phone_number_formats_de_de <- c(
  "+49(0)##########",
  "+49(0)#### ######",
  "+49 (0) #### ######",
  "+49(0) #########",
  "+49(0)#### #####",
  "0##########",
  "0#########",
  "0#### ######",
  "0#### #####",
  "(0####) ######",
  "(0####) #####"
)

phone_number_formats_cs_cz <- c(
  "601 ### ###",
  "603 ### ###",
  "608 ### ###",
  "790 ### ###",
  "602 ### ###",
  "604 ### ###",
  "770 ### ###",
  "606 ### ###",
  "605 ### ###",
  "773 ### ###",
  "607 ### ###",
  "730 ### ###",
  "774 ### ###",
  "702 ### ###",
  "731 ### ###",
  "775 ### ###",
  "720 ### ###",
  "732 ### ###",
  "776 ### ###",
  "721 ### ###",
  "733 ### ###",
  "777 ### ###",
  "722 ### ###",
  "734 ### ###",
  "723 ### ###",
  "736 ### ###",
  "724 ### ###",
  "737 ### ###",
  "725 ### ###",
  "738 ### ###",
  "726 ### ###",
  "739 ### ###",
  "727 ### ###",
  "728 ### ###",
  "729 ### ###"
)

phone_number_formats_bs_ba <- c(
  "030 ### ###",
  "031 ### ###",
  "032 ### ###",
  "033 ### ###",
  "034 ### ###",
  "035 ### ###",
  "036 ### ###",
  "037 ### ###",
  "038 ### ###",
  "039 ### ###",
  "049 ### ###",
  "050 ### ###",
  "051 ### ###",
  "052 ### ###",
  "053 ### ###",
  "054 ### ###",
  "055 ### ###",
  "056 ### ###",
  "057 ### ###",
  "058 ### ###",
  "059 ### ###",
  "060 ### ###",
  "060 #### ###",
  "061 ### ###",
  "062 ### ###",
  "063 ### ###",
  "064 ### ###",
  "065 ### ###",
  "066 ### ###",
  "067 ### ###",
  "070 20# ###",
  "+387 61 ### ###",
  "+387 (0)61 ### ###"
)

phone_number_formats_bg_bg <- c(
  "+359(0)#########",
  "+359(0)### ######",
  "+359(0)### ### ###",
  "+359#########",
  "0#########",
  "0### ######",
  "0### ### ###",
  "0### ###-###",
  "(0###) ######",
  "(0###) ### ###",
  "(0###) ###-###"
)


phone_number_formats_fa_ir <- c(
  # Mobile
  "+98 91# ### ####",
  "091# ### ####",
  "+98 920 ### ####",
  "0920 ### ####",
  "+98 921 ### ####",
  "0921 ### ####",
  "+98 93# ### ####",
  "093# ### ####",
  # Land lines, https://en.wikipedia.org/wiki/List_of_dialling_codes_in_Iran
  "+98 21 #### ####",
  "021 #### ####",
  "+98 26 #### ####",
  "026 #### ####",
  "+98 25 #### ####",
  "025 #### ####",
  "+98 86 #### ####",
  "086 #### ####",
  "+98 24 #### ####",
  "024 #### ####",
  "+98 23 #### ####",
  "023 #### ####",
  "+98 81 #### ####",
  "081 #### ####",
  "+98 28 #### ####",
  "028 #### ####",
  "+98 31 #### ####",
  "031 #### ####",
  "+98 44 #### ####",
  "044 #### ####",
  "+98 11 #### ####",
  "011 #### ####",
  "+98 74 #### ####",
  "074 #### ####",
  "+98 83 #### ####",
  "083 #### ####",
  "+98 51 #### ####",
  "051 #### ####",
  "+98 45 #### ####",
  "045 #### ####",
  "+98 17 #### ####",
  "017 #### ####",
  "+98 41 #### ####",
  "041 #### ####",
  "+98 54 #### ####",
  "054 #### ####",
  "+98 87 #### ####",
  "087 #### ####",
  "+98 71 #### ####",
  "071 #### ####",
  "+98 66 #### ####",
  "066 #### ####",
  "+98 34 #### ####",
  "034 #### ####",
  "+98 56 #### ####",
  "056 #### ####",
  "+98 13 #### ####",
  "013 #### ####",
  "+98 77 #### ####",
  "077 #### ####",
  "+98 76 #### ####",
  "076 #### ####",
  "+98 61 #### ####",
  "061 #### ####",
  "+98 38 #### ####",
  "038 #### ####",
  "+98 58 #### ####",
  "058 #### ####",
  "+98 35 #### ####",
  "035 #### ####",
  "+98 84 #### ####",
  "084 #### ####",
  "+98 ### #### ####",
  "0### #### ####"
)

phone_number_formats_fi_fi <- c(
  "+358 ## #######",
  "+358 #########",
  "+358#########",
  "(+358) #########",
  "0#########",
  "0## ### ####"
)

phone_number_formats_fr_ch <- c(
  "+41 2# ### ## ##",
  "+41 3# ### ## ##",
  "+41 4# ### ## ##",
  "+41 5# ### ## ##",
  "+41 6# ### ## ##",
  "+41 7# ### ## ##",
  "+41 8# ### ## ##",
  "+41 9# ### ## ##",
  "+41 (0)2# ### ## ##",
  "+41 (0)3# ### ## ##",
  "+41 (0)4# ### ## ##",
  "+41 (0)5# ### ## ##",
  "+41 (0)6# ### ## ##",
  "+41 (0)7# ### ## ##",
  "+41 (0)8# ### ## ##",
  "+41 (0)9# ### ## ##",
  "02# ### ## ##",
  "03# ### ## ##",
  "04# ### ## ##",
  "05# ### ## ##",
  "06# ### ## ##",
  "07# ### ## ##",
  "08# ### ## ##",
  "09# ### ## ##",
  # see: http://www.bakom.admin.ch/themen/telekom/00479/00607/index.html
  "084# ### ###",
  "0878 ### ###",
  "0900 ### ###",
  "0901 ### ###",
  "0906 ### ###"
)

phone_number_formats_fr_fr <- c(
  "+33 (0)1 ## ## ## ##",
  "+33 (0)1 ## ## ## ##",
  "+33 (0)2 ## ## ## ##",
  "+33 (0)3 ## ## ## ##",
  "+33 (0)4 ## ## ## ##",
  "+33 (0)5 ## ## ## ##",
  "+33 (0)6 ## ## ## ##",
  "+33 (0)8 ## ## ## ##",
  "+33 1 ## ## ## ##",
  "+33 1 ## ## ## ##",
  "+33 2 ## ## ## ##",
  "+33 3 ## ## ## ##",
  "+33 4 ## ## ## ##",
  "+33 5 ## ## ## ##",
  "+33 6 ## ## ## ##",
  "+33 8 ## ## ## ##",
  "01########",
  "01########",
  "02########",
  "03########",
  "04########",
  "05########",
  "06########",
  "08########",
  "01 ## ## ## ##",
  "01 ## ## ## ##",
  "02 ## ## ## ##",
  "03 ## ## ## ##",
  "04 ## ## ## ##",
  "05 ## ## ## ##",
  "06 ## ## ## ##",
  "08 ## ## ## ##"
)

phone_number_formats_hi_in <- c(
  "+91 ##########",
  "+91 ### #######",
  "0##-########",
  "0##########",
  "0#### ######"
)

phone_number_formats_hr_hr <- c(
  "01 #### ###",
  "020 ### ###",
  "021 ### ###",
  "022 ### ###",
  "023 ### ###",
  "031 ### ###",
  "032 ### ###",
  "033 ### ###",
  "034 ### ###",
  "035 ### ###",
  "040 ### ###",
  "042 ### ###",
  "043 ### ###",
  "044 ### ###",
  "047 ### ###",
  "048 ### ###",
  "049 ### ###",
  "051 ### ###",
  "052 ### ###",
  "053 ### ###",
  "060 ### ###",
  "072 ### ###",
  "074 ### ###",
  "091 #### ###",
  "092 #### ###",
  "095 #### ###",
  "097 #### ###",
  "098 #### ###",
  "099 #### ###",
  "0800 ## ##"
)

phone_number_formats_hu_hu <- c(
  "+36 ## ###-####",
  "(06)##/###-####",
  "(##)/###-####",
  "##/###-####",
  "##/### ####",
  "06-#/### ####",
  "06-##/### ####"
)

phone_number_formats_it_it <- c(
  "+39 ### ## ## ####",
  "+39 ## #######",
  "+39 ## ########",
  "+39 ### #######",
  "+39 ### ########",
  "+39 #### #######",
  "+39 #### ########"
)

phone_number_formats_ja_jp <- c(
  "070-####-####",
  "080-####-####",
  "090-####-####",
  "##-####-####"
)

phone_number_formats_ko_kr <- c(
  "02-####-####",
  "031-###-####",
  "032-###-####",
  "033-###-####",
  "041-###-####",
  "042-###-####",
  "043-###-####",
  "044-###-####",
  "051-###-####",
  "052-###-####",
  "053-###-####",
  "054-###-####",
  "055-###-####",
  "061-###-####",
  "062-###-####",
  "063-###-####",
  "064-7##-####",
  "010-####-####",
  "011-###-####",
  "016-###-####",
  "017-###-####",
  "018-###-####",
  "019-###-####",
  "070-####-####"
)

phone_number_formats_lt_lt <- c(
  "+370 ########",
  "+(370) ########",
  "+370########"
)

phone_number_formats_lv_lv <- c(
  "+371 ########",
  "+(371) ########",
  "+371########"
)

phone_number_formats_ne_np <- c(
  "+977 ##########",
  "+977 ### #######",
  "984#######",
  "985#######",
  "980#######"
)

phone_number_formats_nl_be <- c(
  "0### ######",
  "0## #######",
  "+32### ######",
  "+32## #######",
  "+32(0)### ######",
  "+32(0)## #######",
  "(0###) ######",
  "(0##) #######",
  "0###-######",
  "0##-#######",
  "+32###-######",
  "+32##-#######",
  "+32(0)###-######",
  "+32(0)##-#######",
  "(0###)-######",
  "(0##)-#######"
)

phone_number_formats_nl_nl <- c(
  "0### ######",
  "0## #######",
  "+31### ######",
  "+31## #######",
  "+31(0)### ######",
  "+31(0)## #######",
  "(0###) ######",
  "(0##) #######",
  "0###-######",
  "0##-#######",
  "+31###-######",
  "+31##-#######",
  "+31(0)###-######",
  "+31(0)##-#######",
  "(0###)-######",
  "(0##)-#######"
)

phone_number_formats_no_no <- c(
  "+47#########",
  "+47 ## ## ## ##",
  "## ## ## ##",
  "## ## ## ##",
  "########",
  "########",
  "9## ## ###",
  "4## ## ###",
  "9#######",
  "4#######"
)

phone_number_formats_pl_pl <- c(
  # Mobile
  # Government website: http://www.uke.gov.pl/numeracja-843
  "50# ### ###",
  "51# ### ###",
  "53# ### ###",
  "57# ### ###",
  "60# ### ###",
  "66# ### ###",
  "69# ### ###",
  "72# ### ###",
  "73# ### ###",
  "78# ### ###",
  "79# ### ###",
  "88# ### ###",
  "+48 50# ### ###",
  "+48 51# ### ###",
  "+48 53# ### ###",
  "+48 57# ### ###",
  "+48 60# ### ###",
  "+48 66# ### ###",
  "+48 69# ### ###",
  "+48 72# ### ###",
  "+48 73# ### ###",
  "+48 78# ### ###",
  "+48 79# ### ###",
  "+48 88# ### ###",
  "32 ### ## ##",
  "+48 32 ### ## ##",
  "22 ### ## ##",
  "+48 22 ### ## ##"
)

phone_number_formats_pt_br <- c(
  "+55 (011) #### ####",
  "+55 (021) #### ####",
  "+55 (031) #### ####",
  "+55 (041) #### ####",
  "+55 (051) #### ####",
  "+55 (061) #### ####",
  "+55 (071) #### ####",
  "+55 (081) #### ####",
  "+55 11 #### ####",
  "+55 21 #### ####",
  "+55 31 #### ####",
  "+55 41 #### ####",
  "+55 51 ### ####",
  "+55 61 #### ####",
  "+55 71 #### ####",
  "+55 81 #### ####",
  "+55 (011) ####-####",
  "+55 (021) ####-####",
  "+55 (031) ####-####",
  "+55 (041) ####-####",
  "+55 (051) ####-####",
  "+55 (061) ####-####",
  "+55 (071) ####-####",
  "+55 (081) ####-####",
  "+55 11 ####-####",
  "+55 21 ####-####",
  "+55 31 ####-####",
  "+55 41 ####-####",
  "+55 51 ### ####",
  "+55 61 ####-####",
  "+55 71 ####-####",
  "+55 81 ####-####",
  "(011) #### ####",
  "(021) #### ####",
  "(031) #### ####",
  "(041) #### ####",
  "(051) #### ####",
  "(061) #### ####",
  "(071) #### ####",
  "(081) #### ####",
  "11 #### ####",
  "21 #### ####",
  "31 #### ####",
  "41 #### ####",
  "51 ### ####",
  "61 #### ####",
  "71 #### ####",
  "81 #### ####",
  "(011) ####-####",
  "(021) ####-####",
  "(031) ####-####",
  "(041) ####-####",
  "(051) ####-####",
  "(061) ####-####",
  "(071) ####-####",
  "(081) ####-####",
  "11 ####-####",
  "21 ####-####",
  "31 ####-####",
  "41 ####-####",
  "51 ### ####",
  "61 ####-####",
  "71 ####-####",
  "81 ####-####",
  "#### ####",
  "####-####"
)


phone_number_formats_pt_pt <- c(
  "(351) 91# ### ###",
  "(351) 92# ### ###",
  "(351) 93# ### ###",
  "(351) 96# ### ###",
  "(351) 2## ### ###",
  "(351) 91#######",
  "(351) 92#######",
  "(351) 93#######",
  "(351) 96#######",
  "(351) 2########",
  "(351) 91# ### ###",
  "(351) 92# ### ###",
  "(351) 93# ### ###",
  "(351) 96# ### ###",
  "(351) 2## ### ###",
  "(351) 91#######",
  "(351) 92#######",
  "(351) 93#######",
  "(351) 96#######",
  "(351) 2########",
  "+35191#######",
  "+35192#######",
  "+35193#######",
  "+35196#######",
  "+3512########",
  "91# ### ###",
  "92# ### ###",
  "93# ### ###",
  "96# ### ###",
  "2## ### ###",
  "91#######",
  "92#######",
  "93#######",
  "96#######",
  "2########"
)



phone_number_formats_ru_ru <- c(
  "+7 ### ### ####",
  "+7 ### ### ## ##",
  "+7 (###) ###-##-##",
  "+7 (###) ###-####"
)

phone_number_formats_sk_sk <- c(
  "+421 2 ########",
  "+421 3# ### ####",
  "+421 4# ### ####",
  "+421 5# ### ####",
  "+421 90# ### ###",
  "+421 91# ### ###",
  "+421 940 ### ###",
  "+421 944 ### ###",
  "+421 948 ### ###",
  "+421 949 ### ###"
)


phone_number_formats_sl_sl <- c(
  "040 ### ###",
  "041 ### ###",
  "031 ### ###",
  "030 ### ###",
  "070 ### ###",
  "01 #### ###",
  "02 #### ###",
  "04 #### ###",
  "05 #### ###",
  "06 #### ###",
  "08 #### ###"
)

phone_number_formats_sv_se <- c(
  "+46 (0)8 ### ### ##",
  "+46 (0)## ## ## ##",
  "+46 (0)### ### ##",
  "08-### ### ##",
  "08-### ## ##",
  "08-## ## ##",
  "0##-### ## ##",
  "0##-## ## ##",
  "0###-## ## ##",
  "0###-### ##"
)

phone_number_formats_tr_tr <- c(
  "+90(###)#######",
  "+90 (###) #######",
  "0### ### ## ##",
  "0##########",
  "0###-### ####",
  "(###)### ####",
  "### # ###",
  "+90(###)###-####x###",
  "+90(###)###-####x####"
)

phone_number_formats_uk_ua <- c(
  "###-##-##",
  "### ## ##",
  "0## ### ## ##",
  "0## ###-##-##",
  "+38 ### ###-##-##",
  "+38 ### ###-##-##",
  "+38 (###) ###-##-##",
  "+38 ### ### ## ##"
)

phone_number_formats_zh_tw <- c(
  "(0#) %#######",
  "0#-%#######",
  "0## %#######",
  "09########",
  "09##-######",
  "0#-%######",
  "0# %######"
)

phone_number_formats_he_il <- c(
  "02#######",
  "02-####-###",
  "03#######",
  "03-####-###",
  "04#######",
  "04-####-###",
  "08#######",
  "08-####-###",
  "09#######",
  "09-####-###",
  "05#-###-####",
  "05# ###-####",
  "05# ### ####",
  "05#-#######",
  "05# #######",
  "05########"
)

phone_number_formats_id_id <- c(
  "+62-##-###-####",
  "+62-0##-###-####",
  "+62 (0##) ### ####",
  "+62 (0##) ###-####",
  "+62 (##) ### ####",
  "+62 (##) ###-####",
  "+62-###-###-####",
  "+62-0###-###-####",
  "+62 (0###) ### ####",
  "+62 (0###) ###-####",
  "+62 (###) ### ####",
  "+62 (###) ###-####",
  "(0##) ### ####",
  "(0##) ###-####",
  "(0###) ### ####",
  "(0###) ###-####",
  "08# ### ####",
  "08########"
)

phone_number_formats_th_th <- c(
  "+66 #### ####",
  "+668 #### ####"
)

phone_number_formats_tw_gh <- c(
  "+23327#######",
  "+23357#######",
  "+23355#######",
  "+23324#######",
  "+23354#######",
  "+23320#######",
  "+23350#######",
  "+23326#######",
  "+23356#######",
  "+23328#######",
  "024#######",
  "054#######",
  "055#######",
  "027#######",
  "057#######",
  "020#######",
  "050#######",
  "026#######",
  "056#######",
  "028#######"
)

# phone_number_formats_zh_cn = c(
#
# )
