% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fraudster.R
\name{FraudsterClient}
\alias{FraudsterClient}
\title{FraudsterClient}
\description{
Fraudster R6 client
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{locale}}{(character) the locale to use}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FraudsterClient$new()}}
\item \href{#method-print}{\code{FraudsterClient$print()}}
\item \href{#method-job}{\code{FraudsterClient$job()}}
\item \href{#method-name}{\code{FraudsterClient$name()}}
\item \href{#method-color_name}{\code{FraudsterClient$color_name()}}
\item \href{#method-safe_color_name}{\code{FraudsterClient$safe_color_name()}}
\item \href{#method-hex_color}{\code{FraudsterClient$hex_color()}}
\item \href{#method-safe_hex_color}{\code{FraudsterClient$safe_hex_color()}}
\item \href{#method-rgb_color}{\code{FraudsterClient$rgb_color()}}
\item \href{#method-rgb_css_color}{\code{FraudsterClient$rgb_css_color()}}
\item \href{#method-lat}{\code{FraudsterClient$lat()}}
\item \href{#method-lon}{\code{FraudsterClient$lon()}}
\item \href{#method-position}{\code{FraudsterClient$position()}}
\item \href{#method-doi}{\code{FraudsterClient$doi()}}
\item \href{#method-timezone}{\code{FraudsterClient$timezone()}}
\item \href{#method-unix_time}{\code{FraudsterClient$unix_time()}}
\item \href{#method-date_time}{\code{FraudsterClient$date_time()}}
\item \href{#method-genus}{\code{FraudsterClient$genus()}}
\item \href{#method-epithet}{\code{FraudsterClient$epithet()}}
\item \href{#method-species}{\code{FraudsterClient$species()}}
\item \href{#method-sequence}{\code{FraudsterClient$sequence()}}
\item \href{#method-phone_number}{\code{FraudsterClient$phone_number()}}
\item \href{#method-double}{\code{FraudsterClient$double()}}
\item \href{#method-integer}{\code{FraudsterClient$integer()}}
\item \href{#method-uniform}{\code{FraudsterClient$uniform()}}
\item \href{#method-norm}{\code{FraudsterClient$norm()}}
\item \href{#method-lnorm}{\code{FraudsterClient$lnorm()}}
\item \href{#method-beta}{\code{FraudsterClient$beta()}}
\item \href{#method-currency}{\code{FraudsterClient$currency()}}
\item \href{#method-credit_card_provider}{\code{FraudsterClient$credit_card_provider()}}
\item \href{#method-credit_card_number}{\code{FraudsterClient$credit_card_number()}}
\item \href{#method-credit_card_security_code}{\code{FraudsterClient$credit_card_security_code()}}
\item \href{#method-clone}{\code{FraudsterClient$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{FraudsterClient} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$new(locale = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{locale}}{(character) the locale to use. options: en_US (default),
fr_FR, fr_CH, hr_FR, fa_IR, pl_PL, ru_RU, uk_UA, zh_TW.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{RequestSignature} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
print method for the \code{FraudsterClient} class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$print(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{self}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-job"></a>}}
\subsection{Method \code{job()}}{
jobs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$job(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-name"></a>}}
\subsection{Method \code{name()}}{
names
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$name(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-color_name"></a>}}
\subsection{Method \code{color_name()}}{
colors
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$color_name(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-safe_color_name"></a>}}
\subsection{Method \code{safe_color_name()}}{
safe color name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$safe_color_name(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hex_color"></a>}}
\subsection{Method \code{hex_color()}}{
hex color
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$hex_color(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-safe_hex_color"></a>}}
\subsection{Method \code{safe_hex_color()}}{
safe hex color
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$safe_hex_color(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rgb_color"></a>}}
\subsection{Method \code{rgb_color()}}{
rgb color
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$rgb_color(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rgb_css_color"></a>}}
\subsection{Method \code{rgb_css_color()}}{
rgb css color
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$rgb_css_color(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-lat"></a>}}
\subsection{Method \code{lat()}}{
latitude
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$lat(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-lon"></a>}}
\subsection{Method \code{lon()}}{
longitude
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$lon(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-position"></a>}}
\subsection{Method \code{position()}}{
long/lat coordinate pair
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$position(n = 1, bbox = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}

\item{\code{bbox}}{a bounding box, see \code{\link[=ch_position]{ch_position()}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-doi"></a>}}
\subsection{Method \code{doi()}}{
DOIs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$doi(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-timezone"></a>}}
\subsection{Method \code{timezone()}}{
date times
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$timezone(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-unix_time"></a>}}
\subsection{Method \code{unix_time()}}{
unix time
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$unix_time(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-date_time"></a>}}
\subsection{Method \code{date_time()}}{
date time
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$date_time(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-genus"></a>}}
\subsection{Method \code{genus()}}{
taxonomic genus
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$genus(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-epithet"></a>}}
\subsection{Method \code{epithet()}}{
taxonomic epithet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$epithet(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-species"></a>}}
\subsection{Method \code{species()}}{
taxonomic species (genus + epithet)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$species(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sequence"></a>}}
\subsection{Method \code{sequence()}}{
random genetic sequence
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$sequence(n = 1, length = 30)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}

\item{\code{length}}{(integer) length of the sequence. default: 30}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-phone_number"></a>}}
\subsection{Method \code{phone_number()}}{
phone number
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$phone_number(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-double"></a>}}
\subsection{Method \code{double()}}{
a double
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$double(n = 1, mean = 0, sd = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}

\item{\code{mean}}{mean value, default: 0}

\item{\code{sd}}{standard deviation, default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-integer"></a>}}
\subsection{Method \code{integer()}}{
an integer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$integer(n = 1, min = 1, max = 1000)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}

\item{\code{min}}{minimum value, default: 1}

\item{\code{max}}{maximum value, default: 1000}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-uniform"></a>}}
\subsection{Method \code{uniform()}}{
an integer from a uniform distribution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$uniform(n = 1, min = 0, max = 9999)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}

\item{\code{min}}{minimum value, default: 0}

\item{\code{max}}{maximum value, default: 9999}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-norm"></a>}}
\subsection{Method \code{norm()}}{
an integer from a normal distribution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$norm(n = 1, mean = 0, sd = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}

\item{\code{mean}}{mean value, default: 0}

\item{\code{sd}}{standard deviation, default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-lnorm"></a>}}
\subsection{Method \code{lnorm()}}{
an integer from a lognormal distribution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$lnorm(n = 1, mean = 0, sd = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}

\item{\code{mean}}{mean value, default: 0}

\item{\code{sd}}{standard deviation, default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-beta"></a>}}
\subsection{Method \code{beta()}}{
an integer from a beta distribution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$beta(n = 1, shape1, shape2, ncp = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}

\item{\code{shape1}}{non-negative parameters of the Beta distribution}

\item{\code{shape2}}{non-negative parameters of the Beta distribution}

\item{\code{ncp}}{non-centrality parameter, default: 0}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-currency"></a>}}
\subsection{Method \code{currency()}}{
currency
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$currency(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-credit_card_provider"></a>}}
\subsection{Method \code{credit_card_provider()}}{
credit card provider
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$credit_card_provider(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-credit_card_number"></a>}}
\subsection{Method \code{credit_card_number()}}{
credit card number
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$credit_card_number(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-credit_card_security_code"></a>}}
\subsection{Method \code{credit_card_security_code()}}{
credit card security code
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$credit_card_security_code(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of random things to generaate. an integer; default: 1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FraudsterClient$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
