% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy-provider.R
\docType{data}
\name{TaxonomyProvider}
\alias{TaxonomyProvider}
\title{TaxonomyProvider}
\description{
TaxonomyProvider
}
\details{
\strong{Methods}
\itemize{
\item \code{genus()} - Get a genus name
\item \code{epithet()} - Get an epithet name
\item \code{species(authority, date)} - Get a binomial name (genus + epithet)
- authority: Include authority. default: \code{FALSE}
- date: Include authority date. If \code{authority = FALSE},
this is ignored. default: \code{FALSE}
}
}
\section{Names}{

Names were taken from Theplantlist. 500 genera names and 500
epithets were chosen at random from the set of 10,000 names in the
dataset in the \code{taxize} package. Theplantlist is, as it says on the
tin, composed of plant names - so these fake names are derived from
plant names if that matters to you. These may generate names that match
those of real taxa, but may not as well.
}

\section{Taxonomic authority}{

Randomly, the taxonomic authority is in parentheses - which represents
that the given authority was not the original authority.
}

\examples{
(z <- TaxonomyProvider$new())
z$genus()
z$epithet()
z$species()
z$species(authority = TRUE)
## FIXME - datetimeprovider slow - may be related to unix time problem
# z$species(authority = TRUE, date = TRUE)
}
\keyword{internal}
