% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratioOverlap.R
\name{ratioOverlap}
\alias{ratioOverlap}
\title{Calculate the proportion of a range area that is either 1: contained by geographic categories, or 2: correlated with
a continuous environmental layer.}
\usage{
ratioOverlap(
  r,
  shp = NULL,
  rasMask = NULL,
  field = NULL,
  category = NULL,
  subfield = FALSE,
  quant = "quartile"
)
}
\arguments{
\item{r}{either categorical raster or shapefile object representing a binary range.}

\item{shp}{either 1) a shapefile of land cover features or 2) a continuous raster. Must be in same projection as r parameter. If shp is a raster, then the number of cells within each quantile are calculated.}

\item{rasMask}{(optional) a raster layer to calculate the Pearson correlation with the object r. Only if r or shp is a raster layer.}

\item{field}{The shapefile field attribute containing the features to compare (i.e., the column name).}

\item{category}{a list of the names of shapefile features to compare. If all features are to be used, input "All".}

\item{subfield}{boolean. If TRUE, the overlap ratio of all unique categories of shp will be calculated.}

\item{quant}{Either the character string "quartile" for the ratio of each quartile, or a concatenation of values to use instead.}
}
\value{
a list of three objects. The first object is a raster object showing the masked range. The second is a character showing the
percentage of range within the category of interest. The third shows the correlation with rasMask if it is supplied.
}
\description{
Calculate the proportion of the species' range (e.g., a thresholded SDM) that is contained by landcover categories
taken from a shapefile. Example shapefile categories include protected areas, threatened areas. ratioOverlap returns a list
of the masked raster layer and the percent of the total range that lies within the shapefile polygons specified. If shp is a raster
representing an environmental layer, the proportion of presence within quantiles of the environmental layer and the correlation
between the layer and the range are returned.
}
\examples{
# create binary raster
r <- raster::raster(nrows=108, ncols=108, xmn=-50, xmx=50)
raster::values(r)<- runif(n = (108*108))
r[r < 0.5] <- NA
r[r > 0.5] <- 1
# create shp
shp <- raster::raster(nrows=108, ncols=108, xmn=-50, xmx=50)
raster::values(shp)<- runif(n = (108*108))
# ratioOverlap
ratioOverlap(r = r, shp = shp)
}
