% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summary_print.R
\name{summary.chandwich}
\alias{summary.chandwich}
\title{Summarizing adjusted loglikelihoods}
\usage{
\method{summary}{chandwich}(object, digits = max(3, getOption("digits") - 3L),
  ...)
}
\arguments{
\item{object}{an object of class "chandwich", a result of a call to
\code{adjust_loglik}.}

\item{digits}{An integer. Used for number formatting with
\code{\link{signif}}.}

\item{...}{Additional optional arguments. At present no optional
arguments are used.}
}
\value{
Returns a numeric matrix with 3 columns and the number of rows
  equal to the number of parameters in the current model, i.e.
  \code{attr(object, "p_current")}.
  The columns contain: the maximum likelihood estimates (MLE), unadjusted
  standard errors (SE) and adjusted standard errors (adjSE).
}
\description{
\code{summary} method for class "chandwich"
}
\section{Examples}{

See the examples in \code{\link{adjust_loglik}}.
}

\seealso{
\code{\link{adjust_loglik}} to adjust a user-supplied
  loglikelihood function.

\code{\link{plot.chandwich}} for plots of one-dimensional adjusted
  loglikelihoods.
}
