% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cgaim.R
\name{plot.cgaim}
\alias{plot.cgaim}
\title{Plot ridge function}
\usage{
\method{plot}{cgaim}(x, select = NULL, ci = NULL, ci.plot = c("polygon",
  "lines"), ci.args = list(), add = FALSE, xcenter = FALSE,
  xscale = FALSE, yshift = FALSE, yscale = FALSE, ...)
}
\arguments{
\item{x}{A \code{cgaim} object.}

\item{select}{A numeric or character vector indicating which terms
to plot.}

\item{ci}{An object returned by a call to \code{\link{confint.cgaim}}. If
\code{NULL}, no confidence interval is drawn.}

\item{ci.plot}{Whether to plot the confidence intervals as shaded areas
\code{ci.plot = "polygon"} or as lines \code{ci.plot = "lines"}.}

\item{ci.args}{Additional arguments to be passed to the function used
to draw confidence interval. Either \code{\link[graphics]{polygon}} or
\code{\link[graphics]{lines}}.}

\item{add}{Logical. If TRUE, adds the function to the current active plot.}

\item{xcenter, xscale}{Centering and scaling values for the x axis. See
\code{\link[base]{scale}}.}

\item{yshift, yscale}{Either logical or numeric values to shift and scale 
the ridge functions. See details.}

\item{...}{Additional graphical parameters for the drawn function. See
\code{\link[graphics]{par}}.}
}
\value{
The function is called to generate plots and returns no value.
}
\description{
Plot method for the ridge and smooth terms of a \code{cgaim} object. If
   provided, also plots confidence intervals.
}
\details{
The values of \code{yshift} and \code{yscale} determine how
ridge functions are shifted and scaled for plotting. This can be used to
display the functions over data points for instance. If numeric, a vector
can be passed with one value for each plotted function. The vector is 
recycled if necessary. This indicate the desired mean and standard deviation 
of plotted ridge functions. Note that this is inverse to the parameters
in \code{\link[base]{scale}} (and \code{xcenter,xscale}).
If TRUE is passed instead, functions are shifted
to the intercept and scaled to their corresponding beta coefficients, placing
them on the response scale.
}
\examples{
## Simulate some data
n <- 200
x1 <- rnorm(n)
x2 <- rnorm(n)
x3 <- rnorm(n)
x4 <- rnorm(n)
mu <- 4 * exp(8 * x1) / (1 + exp(8 * x1)) + exp(x3)
y <- 5 + mu + rnorm(n)
df1 <- data.frame(y, x1, x2, x3, x4)

## Fit a model
ans <- cgaim(y ~ g(x1, x2, label = "foo") + g(x3, x4, label = "bar"), 
  data = df1)

## Default plot method
plot(ans)

## Select variable
plot(ans, select = 1)

# Same as
plot(ans, select = "foo")

## Add confidence intervals
ci <- confint(ans)
plot(ans, select = 1, ci = ci)

## Change scale and location
# On the response scale
plot(ans, select = 1, ci = ci, yshift = TRUE, yscale = TRUE)

# Arbitrary scale
plot(ans, select = 1, ci = ci, yshift = 1000)

## Change look

# Main line
plot(ans, select = 1, ci = ci, col = 2, lwd = 3)

# Confidence intervals
plot(ans, select = 1, ci = ci, col = 2, lwd = 3,
  ci.args = list(col = adjustcolor(2, .5)))

# Confidence interval type
plot(ans, select = 1, ci = ci, ci.plot = "lines", col = 2, lwd = 3,
  ci.args = list(col = 2, lty = 4))

## Put curves on the same plot (need to shift and scale)
plot(ans, select = 1, col = 2, ylim = c(-2, 3))
plot(ans, select = 2, col = 4, add = TRUE)

}
\seealso{
\code{\link{cgaim}} for the main fitting function and 
  \code{\link{confint.cgaim}} for confidence interval computation.
}
