% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_severity.R
\name{.estimate_severity}
\alias{.estimate_severity}
\title{Estimate the corrected case fatality risk}
\usage{
.estimate_severity(
  total_cases,
  total_deaths,
  total_outcomes,
  poisson_threshold,
  p_mid = total_deaths/round(total_outcomes)
)
}
\arguments{
\item{total_cases}{The total number of cases observed over the period of an
outbreak of interest. The total number of cases must be greater than or equal
to the total number of deaths.}

\item{total_deaths}{The total number of deaths observed over the period of an
outbreak of interest. The total number of deaths must be less than or equal
to the total number of cases.}

\item{total_outcomes}{The total number of outcomes expected to be observed
over the period of an outbreak of interest. See \code{\link[=estimate_outcomes]{estimate_outcomes()}}.}

\item{poisson_threshold}{The case count above which to use Poisson
approximation. Set to 100 by default. Must be > 0.}

\item{p_mid}{The initial severity estimate, which is used to determine the
likelihood approximation used when \code{total_cases} > \code{poisson_threshold}.
Defaults to \code{total_deaths / round(total_outcomes)}.}
}
\value{
A \verb{<data.frame>} with one row and three columns for the maximum
likelihood estimate and 95\% confidence interval of the corrected severity
estimates, named "severity_estimate", "severity_low", and "severity_high".
}
\description{
Estimates the maximum likelihood estimate and 95\% confidence
interval of a corrected severity, using the total cases and total cases with
known outcomes, where the latter replaces the total number of deaths in the
standard (naive) severity definition. We use a binomial likelihood,
approximated by a Poisson likelihood for large samples.
}
\details{
\subsection{Special cases}{
\itemize{
\item When any two of \code{total_cases}, \code{total_deaths}, or \code{total_outcomes} are 0,
the estimate and confidence intervals cannot be calculated and the output
\verb{<data.frame>} contains only \code{NA}s.
\item When \code{total_outcomes <= total_deaths}, estimate and confidence intervals
cannot be reliably calculated and are returned as \code{NA}.
}
}
}
\keyword{internal}
