% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_severity.R
\name{.select_func_likelihood}
\alias{.select_func_likelihood}
\title{Select a likelihood function for severity estimation}
\usage{
.select_func_likelihood(total_cases, poisson_threshold, p_mid)
}
\arguments{
\item{total_cases}{A single count for the total number of cases in the
outbreak.}

\item{poisson_threshold}{A single count for the threshold of cases above
which a Poisson or Normal approximation is returned.}

\item{p_mid}{A single positive number bounded 0 -- 1, representing an initial
estimate of the severity, which is used to determine whether a Poisson or
Normal approximation is returned.
determine whether}
}
\value{
A function with three arguments, \code{total_outcomes}, \code{total_deaths},
and \code{pp}, which is used to generate the profile likelihood.
Also prints messages to the screen when a Poisson or Normal approximation
function is returned.
}
\description{
Switches between Binomial, Poisson, and Normal approximation based on the
total number of cases and an initial estimate of the severity.
}
\details{
Returns a likelihood function as follows:
\itemize{
\item Binomial approximation: when \code{total_cases < poisson_threshold},
used when there are few cases, such as in a small outbreak;
\item Poisson approximation: when \code{total_cases >= poisson_threshold} but
when \code{p_mid} < 0.05;
\item Normal approximation: when \code{total_cases >= poisson_threshold} and
\verb{p_mid >=} 0.05.
}
}
\keyword{internal}
