% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.R
\name{hist.njump}
\alias{hist.njump}
\title{Plot the number of jumps}
\usage{
\method{hist}{njump}(x, breaks = NULL, ...)
}
\arguments{
\item{x}{output of \code{\link{compute_number_jumps}} function}

\item{breaks}{number of breaks. If not given, use the Sturges rule}

\item{...}{parameters for \code{geom_histogram}}
}
\value{
a \code{ggplot} object that can be modified using \code{ggplot2} package.
}
\description{
Plot the number of jumps
}
\examples{
# Simulate the Jukes-Cantor model of nucleotide replacement
K <- 4
PJK <- matrix(1 / 3, nrow = K, ncol = K) - diag(rep(1 / 3, K))
lambda_PJK <- c(1, 1, 1, 1)
d_JK <- generate_Markov(n = 10, K = K, P = PJK, lambda = lambda_PJK, Tmax = 10)

nJump <- compute_number_jumps(d_JK)

hist(nJump)

# modify the plot using ggplot2
library(ggplot2)
hist(nJump, fill = "#984EA3") +
  labs(title = "Distribution of the number of jumps")
}
\author{
Quentin Grimonprez
}
