% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstructData.R
\name{plotIndicatorsReconstruction}
\alias{plotIndicatorsReconstruction}
\title{Plot reconstructed indicators}
\usage{
plotIndicatorsReconstruction(reconstruction, id, states = NULL)
}
\arguments{
\item{reconstruction}{output of \code{\link{reconstructIndicators}}}

\item{id}{id of the individual to plot. \code{id} must be in \code{reconstruction$id}}

\item{states}{states to plot, by default all states are plotted}
}
\value{
ggplot
}
\description{
Plot reconstructed indicators
}
\examples{
set.seed(42)
# Simulate the Jukes-Cantor model of nucleotide replacement
K <- 3
Tmax <- 1
d_JK <- generate_Markov(n = 100, K = K, Tmax = Tmax)
d_JK2 <- cut_data(d_JK, Tmax)

# create basis object
m <- 20
b <- create.bspline.basis(c(0, Tmax), nbasis = m, norder = 4)
\donttest{
# compute encoding
encoding <- compute_optimal_encoding(d_JK2, b, computeCI = FALSE, nCores = 1)

indicators <- reconstructIndicators(encoding)

# we plot the first path and its reconstructed indicators
iInd <- 3
plotData(d_JK2[d_JK2$id == iInd, ])

plotIndicatorsReconstruction(indicators, id = iInd)

# the column state contains the state associated with the greatest indicator.
# So, the output can be used with plotData function
plotData(remove_duplicated_states(indicators[indicators$id == iInd, ]))
}
}
\seealso{
\code{\link{reconstructIndicators}}
}
\author{
Quentin Grimonprez
}
