% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.r
\name{censys_export_job_status}
\alias{censys_export_job_status}
\title{Get status of a Censys export job}
\usage{
censys_export_job_status(job_id)
}
\arguments{
\item{job_id}{Censys export job id (from calling \code{censys_start_export()})}
}
\value{
API call result (invisibly)
}
\description{
The Get Job Status endpoint lets you retrieved information about a previously submitted
job. The status field will return "pending" until the job has completed at which time
status will be "success" or "error". On success, the output will define download_paths,
a list of files that can be downloaded for the next 24 hours. After 24 hour, the job
status will change to "expired" and the files will no longer be retrievable.
}
\details{
You must have both \code{CENSYS_API_ID} and \code{CENSYS_API_SECRET} present in the
R environment for the functions in this package to work. It is highly suggested that
you place those in \code{~/.Renviron} at least for interactive work.
}
\examples{
\dontrun{
q <- censys_start_export("
SELECT location.country, count(ip) FROM ipv4.20161206 GROUP BY location.country
")
censys_export_job_status(q$job_id)
censys_export_download(q$job_id, "~/Data")
}
}
\references{
Censys SQL query syntax: \url{https://censys.io/query};
            API doc: \url{https://censys.io/api/v1/docs/export}
}

