% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angle-functions.R
\name{distanceCells}
\alias{distanceCells}
\title{Minimum Distance between Two Cells}
\usage{
distanceCells(X, cellids)
}
\arguments{
\item{X}{a tracks object}

\item{cellids}{a vector of two indices specifying the tracks to compute distance between.}
}
\value{
A single distance, or NA if the the tracks do not have overlapping timepoints.
}
\description{
Compute the minimum distance between two cells in the dataset (minimum over all)
the timepoints where they were both measured.
}
\examples{
## Find the minimum distance between the tracks with ids 1 and 2
distanceCells( TCells, c("1","2") )
}
\seealso{
\code{\link{angleCells}} to compute the angle between the track displacement vectors,
and \code{\link{AngleAnalysis}} for other methods to compute angles and distances.
}
