% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atp_plot.R
\name{atp_plot}
\alias{atp_plot}
\title{ATP Plot}
\usage{
atp_plot(
  energetics,
  error_bar = "ci",
  conf_int = 0.95,
  size = 2,
  shape = 21,
  basal_vs_max = "basal",
  glyc_vs_resp = "glyc",
  group_label = "Experimental group"
)
}
\arguments{
\item{energetics}{A table of calculated glycolysis and OXPHOS rates.
Returned by \code{get_energetics}}

\item{error_bar}{Whether to plot error bars as standard deviation (\code{"sd"})
or confidence intervals (\code{"ci"})}

\item{conf_int}{The confidence interval percentage. Should be between 0 and 1}

\item{size}{Size of the points}

\item{shape}{Shape of the points}

\item{basal_vs_max}{Whether to plot \code{"basal"} or \code{"max"} respiration}

\item{glyc_vs_resp}{Whether to plot glycolysis (\code{"glyc"})  or respiration (\code{"resp"})}

\item{group_label}{Label for the experimental group to populate the legend title}
}
\value{
a ggplot
}
\description{
Generate the ATP Plot
}
\details{
\strong{Note:}
When we use the term 'max' in the package documentation we mean the maximal
experimental OCR and ECAR values rather than absolute biological maximums.
}
\examples{
rep_list <- system.file("extdata", package = "ceas") |>
  list.files(pattern = "*.xlsx", full.names = TRUE)
seahorse_rates <- read_data(rep_list, sheet = 2)
partitioned_data <- partition_data(seahorse_rates)
energetics <- get_energetics(partitioned_data, ph = 7.4, pka = 6.093, buffer = 0.1)
atp_plot(energetics)

atp_plot(energetics, basal_vs_max = "max")

atp_plot(energetics, basal_vs_max = "basal", glyc_vs_resp = "resp")

# to change fill, the geom_point shape number should be between 15 and 25
atp_plot(energetics, shape = 21) + # filled circle
  ggplot2::scale_fill_manual(values = c("#e36500", "#b52356", "#3cb62d", "#328fe1"))

# to change color, use ggplot2::scale_color_manual
atp_plot(energetics) +
  ggplot2::scale_color_manual(values = c("#e36500", "#b52356", "#3cb62d", "#328fe1"))
}
