% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loginCDRC.R
\name{loginCDRC}
\alias{loginCDRC}
\title{Login to the CDRC}
\usage{
loginCDRC(username, password)
}
\arguments{
\item{username}{A character-string with your CDRC username.}

\item{password}{A character-string with your CDRC password.}
}
\value{
A response message which confirms the login was successful and how to see the API key.
}
\description{
This function will log in a CDRC user based on the username and password. If you do not
have a CDRC user yet, please register on https://apps.cdrc.ac.uk/datasetportal/Identity/Account/Register
When you log in an api token is automatically generated, saved in your R environment and loaded, no further action is required from you to access the API.
}
\details{
For safety reasons the API token will expire in 24h. This means that after 24h you need to log in again to generate a new API token which will be self-updated and load.
}
\examples{
\dontrun{
loginCDRC(name='your-username',password='your-password')
}
}
