% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmi.R
\name{adjusted_bmi_fun}
\alias{adjusted_bmi_fun}
\title{Adjusted Body Mass Index (BMI) derived variable}
\usage{
adjusted_bmi_fun(DHH_SEX, HWTGHTM, HWTGWTK)
}
\arguments{
\item{DHH_SEX}{CCHS variable for sex; 1 = male, 2 = female}

\item{HWTGHTM}{CCHS variable for height (in meters)}

\item{HWTGWTK}{CCHS variable for weight (in kilograms)}
}
\value{
numeric value for adjusted BMI in the HWTGCOR_der variable
}
\description{
This function creates a harmonized adjusted BMI variable. 
A systematic review of the literature concluded that the use of 
self-reported data among adults underestimates weight and overestimates 
height, resulting in lower estimates of obesity than those obtained from 
measured data. Using data from the 2005 Canadian Community Health Survey 
(CCHS) subsample, where both measured and self-reported values were 
collected, correction equations have been developed 
(Connor Gorber et al. 2008). Differences between corrected estimates of 
obesity from the CCHS and measured estimates from the Canadian Health 
Measures Survey is monitored over time to determine if the bias in 
self-reported values is changing and if new correction equations need to be 
developed. Adjusted BMI variable is first introduced in the CCHS 2015 cycle.

 adjusted_bmi_fun() creates a derived variable (HWTGCOR_der) that is 
 harmonized across all CCHS cycles. This function takes the BMI by dividing 
 weight by the square of height, and adds a correction value based on sex.
}
\details{
For HWTGCOR_der, there are no restrictions to age, height, weight,
 or pregnancy status. While pregnancy was consistent across all CCHS cycles,
 its variable (MAM_037) was not available in the PUMF CCHS datasets so it
 could not be harmonized and included into the function.

 HWTGCOR_der uses the CCHS variables for sex, height and weight that have been
 transformed by cchsflow. In order to generate a value for adjusted BMI 
 across CCHS cycles, sex, height and weight must be transformed and 
 harmonized.
}
\note{
In earlier CCHS cycles (2001 and 2003), height was collected in inches;
 while in later CCHS cycles (2005+) it was collected in meters. To harmonize
 values across cycles, height was converted to meters (to 3 decimal points).
 Weight was collected in kilograms across all CCHS cycles, so no
 transformations were required in the harmonization process.
}
\examples{
# Using adjusted_bmi_fun() to create adjusted BMI values between cycles
# adjusted_bmi_fun() is specified in variable_details.csv along with the
# CCHS variables and cycles included.

# To transform the derived BMI variable, use rec_with_table() for each cycle
# and specify HWTGCOR_der, along with sex (DHH_SEX), height (HWTGHTM) and 
# weight (HWTGWTK).Then by using merge_rec_data(), you can combined 
# HWTGBMI_der across cycles.

library(cchsflow)
adjustedbmi2001 <- rec_with_table(
  cchs2001_p, c(
    "HWTGHTM",
    "HWTGWTK", 
    "DHH_SEX",
    "HWTGCOR_der"
  )
)

head(adjustedbmi2001)

adjustedbmi2011_2012 <- rec_with_table(
  cchs2011_2012_p, c(
    "HWTGHTM",
    "HWTGWTK", 
    "DHH_SEX",
    "HWTGCOR_der"
  )
)

tail(adjustedbmi2011_2012)

combined_bmi <- merge_rec_data(adjustedbmi2001, adjustedbmi2011_2012)
head(combined_bmi)
tail(combined_bmi)

# adjusted_bmi_fun() can also generate a value for BMI if you input your sex, 
# and a value for height and weight. Let's say your sex is male, height is 
# 170cm (1.7m) and your weight is 50kg, your BMI can be calculated as follows:

library(cchsflow)
adjusted_BMI <- adjusted_bmi_fun(DHH_SEX = 1, HWTGHTM = 1.7, HWTGWTK = 50)
print(adjusted_BMI)
}
