% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alcohol.R
\name{binge_drinker_fun}
\alias{binge_drinker_fun}
\title{Binge drinking}
\usage{
binge_drinker_fun(
  DHH_SEX,
  ALW_2A1,
  ALW_2A2,
  ALW_2A3,
  ALW_2A4,
  ALW_2A5,
  ALW_2A6,
  ALW_2A7
)
}
\arguments{
\item{DHH_SEX}{sex of respondent (1 - male, 2 - female)}

\item{ALW_2A1}{Number of drinks on Sunday}

\item{ALW_2A2}{Number of drinks on Monday}

\item{ALW_2A3}{Number of drinks on Tuesday}

\item{ALW_2A4}{Number of drinks on Wednesday}

\item{ALW_2A5}{Number of drinks on Thursday}

\item{ALW_2A6}{Number of drinks on Friday}

\item{ALW_2A7}{Number of drinks on Saturday}
}
\value{
Categorical variable (binge_drinker) with two categories:

 \enumerate{
  \item 1 - binge drinker
  \item 2 - non-binge drinker
 }
}
\description{
This function creates a derived categorical variable that
 flags for binge drinking based on the number drinks consumed on a single
 day.
}
\details{
In health research, binge drinking is defined as having an excess
 amount of alcohol in a single day. For males, this is defined as having five
 or more drinks; and for females it is four or more drinks. In the CCHS,
 respondents are asked to count the number of drinks they had during each
 day of the last week.
}
\examples{
# Using binge_drinker_fun() to create binge_drinker values across CCHS cycles
# binge_drinker_fun() is specified in variable_details.csv along with the
# CCHS variables and cycles included.

# To transform binge_drinker, use rec_with_table() for each CCHS cycle
# and specify binge_drinker, along with the various alcohol and sex
# variables. Then by using bind_rows() you can combine binge_drinker
# across cycles.

library(cchsflow)
binge2001 <- rec_with_table(
  cchs2001, c(
    "DHH_SEX", "ALW_2A1", "ALW_2A2", "ALW_2A3", "ALW_2A4", "ALW_2A5",
    "ALW_2A6", "ALW_2A7", "binge_drinker"
  )
)

head(binge2001)

binge2010 <- rec_with_table(
  cchs2010, c(
    "DHH_SEX", "ALW_2A1", "ALW_2A2", "ALW_2A3", "ALW_2A4", "ALW_2A5",
    "ALW_2A6", "ALW_2A7", "binge_drinker"
  )
)

tail(binge2010)

combined_binge <- bind_rows(binge2001, binge2010)

head(combined_binge)

tail(combined_binge)

# Using binge_drinker_fun() to generate binge_drinker with user-inputted
# values.
#
# Let's say you are a male, and you had 3 drinks on Sunday, 1 drink on
# Monday, 6 drinks on Tuesday, 0 drinks on Wednesday, 3 drinks on Thurday,
# 8 drinks on Friday, and 2 drinks on Saturday. Using binge_drinker_fun(),
# we can check if you would be classified as a drinker.

binge <- binge_drinker_fun(DHH_SEX = 1, ALW_2A1 = 3, ALW_2A2 = 1,
                          ALW_2A3 = 6, ALW_2A4 = 0, ALW_2A5 = 3,
                          ALW_2A6 = 8, ALW_2A7 = 2)

print(binge)
}
