% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{adult_services}
\alias{adult_services}
\title{Data from a survey of internet-mediated sex workers}
\format{
A data frame with 1787 rows and 31 variables
\describe{
\item{id}{Provider identifier}
\item{session}{Client session identifier}
\item{age}{Age of provider}
\item{age_cl}{Age of Client}
\item{appearance_cl}{Client Attractiveness (Scale of 1 to 10)}
\item{bmi}{Body Mass Index}
\item{schooling}{Imputed Years of Schooling}
\item{asq_cl}{Age of Client Squared}
\item{provider_second}{Second Provider Involved}
\item{asian_cl}{Asian Client}
\item{black_cl}{Black Client}
\item{hispanic_cl}{Hispanic Client}
\item{othrace_cl}{Other Ethnicity Client}
\item{reg}{Client was a Regular}
\item{hot}{Met Client in Hotel}
\item{massage_cl}{Gave Client a Massage}
\item{lnw}{Log of Hourly Wage}
\item{llength}{Ln(Length)}
\item{unsafe}{Unprotected sex with client of any kind}
\item{asian}{race==1. Asian}
\item{black}{race==2. Black}
\item{hispanic}{race==3. Hispanic}
\item{other}{race==4. Other}
\item{white}{race==5. White}
\item{asq}{Age of provider squared}
\item{cohab}{ms==Cohabitating (living with a partner) but unmarried}
\item{married}{ms==Currently married and living with your spouse}
\item{divorced}{ms==Divorced and not remarried}
\item{separated}{ms==Married but not currently living with your spouse}
\item{nevermarried}{ms==Single and never married}
\item{widowed}{ms==Widowed and not remarried}
}
}
\source{
Cunningham, Scott, and Todd D. Kendall. 2011. “Prostitution 2.0: The Changing Face of Sex Work.” Journal of Urban Economics 69: 273–87.

Cunningham, Scott, and Todd D. Kendall. 2014. “Examining the Role of Client Reviews and Reputation Within Online Prostitution.” In, edited by Scott Cunningham and Manisha Shah. Vol. Handbook on the Economics of Prostitution. Oxford University Press.

Cunningham, Scott, and Todd D. Kendall. 2016. “Prostitution Labor Supply and Education.” Review of Economics of the Household. Forthcoming.
}
\usage{
adult_services
}
\description{
This data comes from a survey of 700 internet-mediated sex workers in 2008 and 2009, asking the same sex workers standard labor market information over several time periods.
}
\details{
This data is used in the \emph{Panel Data} chapter of \emph{Causal Inference: The Mixtape} by Cunningham.
}
\references{
Cunningham. 2021. Causal Inference: The Mixtape. Yale Press. \url{https://mixtape.scunning.com/index.html}.
}
\keyword{datasets}
