% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causalOT-package.R
\docType{data}
\name{pph}
\alias{pph}
\title{An external control trial of treatments for post-partum hemorrhage}
\format{
A matrix with 395 rows and 16 variables
}
\usage{
data(pph)
}
\description{
A dataset evaluating treatments for post-partum hemorrhage. The data contain a treatment group receiving misoprostol vs potential
controls from other locations that received only oxytocin. This data takes the misoprostol group from Egypt and compares them to the oxytocin groups from Burkina Faso, Thailand, and two sites in Vietnam. The data is
stored as a numeric matrix.
}
\details{
The variables are as follows:
\itemize{
\item tx. The treatment indicator of whether an individual received misoprostol (1) or oxytocin (0).
\item cum_blood_20m. The outcome variable denoting cumulative blood loss after 20 minutes in mL (650 -- 2000).
\item age. the mother's age in years (15 -- 43).
\item no_educ. whether a woman had no education (1) or some education (0).
\item num_livebirth. the number of previous live births.
\item cur_married. whether a mother is currently married (1 = yes, 0 = no).
\item gest_age. the gestational age of the fetus in weeks (35 -- 43).
\item prev_pphyes. whether the woman has had a previous post-partum hemorrahge.
\item hb_test. the woman's hemoglobin in mg/dL (7 -- 15).
\item induced_laboryes. whether labor was induced (1 = yes, 0 = no).
\item augmented_laboryes. whether labor was augmented (1 = yes, 0 = no).
\item early_cordclampyes. whether the umbillical cord was clamped early (1 = yes, 0 = no).
\item control_cordtractionyes. whether cord traction was controlled (1 = yes, 0 = no).
\item uterine_massageyes. whether a uterine massage was given (1 = yes, 0 = no).
\item placenta. whether placenta was delivered before treatment given (1 = yes, 0 = no).
\item bloodlossattx. amount of blood lost when treatment given (500 mL -- 1800 mL)
}
}
\seealso{
Data from the following Harvard Dataverse:
\itemize{
\item Winikoff, Beverly, 2019, "Two randomized controlled trials of misoprostol for the treatment of postpartum hemorrhage", https://doi.org/10.7910/DVN/ETHH4N, Harvard Dataverse, V1.
}
The data was originally analyzed in
\itemize{
\item Blum, J. et al. Treatment of post-partum haemorrhage with sublingual misoprostol versus oxytocin in women receiving prophylactic oxytocin: a double-blind, randomised, non-inferiority trial. The Lancet 375, 217--223 (2010).
}
}
\keyword{datasets}
