\name{plot_dens}
\alias{plot_dens}

\title{
	Plot function to represent density of trait values
}

\description{
	Plot function to represent density of trait values
}

\usage{
	plot_dens(traits=NULL, var.1=NULL, var.2=NULL, col.dens=NULL, 
	plot.ask=TRUE, ylim.cex=1, cex.leg=0.8, polyg=TRUE, 
	multipanel=TRUE, leg=TRUE)
}

\arguments{
	\item{traits}{
		Matrix of traits with traits in column.
	}
	
	\item{var.1}{
		The first variable defines the division of each plots, in most case either a vector of species or name of sites.
	}
	
	\item{var.2}{
		The second variable define the division by color, in most case either a vector of species or name of sites.
	}
	
	\item{col.dens}{
		A vector of colors for the second variable.
	}
	
	\item{plot.ask}{
		Logical value; ask for plotting the next plot or not.
	}
	
	\item{ylim.cex}{
		Numeric value; the magnification to be used for range of y axe
	}
	
	\item{cex.leg}{
		Numeric value; the magnification to be used for legend relative to the current setting of cex
	}
	
	\item{polyg}{
		Logical value; do the mean distribution is full or empty
	}
	
	\item{multipanel}{
		Logical value. If TRUE divides the device to shown several traits graphics in the same device. 
	}
	
	\item{leg}{
		Logical value; if TRUE print the legend.
	}
	
	
}

\value{
	None; used for the side-effect of producing a plot.
}


\author{
	Adrien Taudiere
}

\seealso{
	\code{\link{plot_sp_pop}}
}

\examples{	
	data(finch.ind)
	
	#Plot the distribution of trait values for populations, 
	#species, sites and regional scales. 
	
	#First, let try the distribution for all populations 
	#of Darwin finches.
	
	par(mfrow=c(4,4), cex=0.5)
	
	plot_dens(traits.finch, sp.finch, ind.plot.finch, ylim.cex=3, 
	plot.ask=FALSE, multipanel=FALSE, leg=FALSE)
	
	par(mfrow=c(1,1), cex=1)
	
	
	#Then we can inverse the second and the third arguments 
	#to plot the distribution for all finches species. 
	
	par(mfrow=c(4,4), cex=0.5)
	
	plot_dens(traits.finch, ind.plot.finch, sp.finch, ylim.cex=8, 
	plot.ask=FALSE, multipanel=FALSE, leg=FALSE)
	
	par(mfrow=c(1,1), cex=1)
	
	
	#You can also plot trait distribution for all species in the region
	
	plot_dens(traits.finch, rep("region", times=dim(traits.finch)[1]), 
	sp.finch, ylim.cex=6, plot.ask=FALSE, leg=FALSE)
	
	
	#You can also plot trait distribution for all sites
	#without taking into account species identity
	
	plot_dens(traits.finch, rep("toutes_sp", times=dim(traits.finch)[1]), 
	ind.plot.finch, ylim.cex=3, plot.ask=FALSE)
	
	par(mfrow=c(4,4), cex=0.5)
}






