% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pLift.R
\encoding{UTF-8}
\name{pLift}
\alias{pLift}
\title{Penalty-Lift Analysis}
\usage{
pLift(X, Y)
}
\arguments{
\item{X}{\emph{either} a matrix of CATA data with \code{I} consumers (rows)
and \code{J} products (columns) \emph{or} an array of CATA data with 
\code{I} consumers, \code{J} products, and \code{M} attributes.}

\item{Y}{matrix of hedonic data with \code{I} consumers (rows)
and \code{J} products (columns)}
}
\value{
Penalty lift for the attribute if \code{X} is a matrix; otherwise,
penalty-lift for each attribute if \code{X} is a 3d array. If an attributes 
is only checked or not check then \code{NA} is returned.
}
\description{
Penalty-Lift analysis for CATA variables, which is the difference between
the average hedonic response when CATA attribute is checked vs. the average
hedonic response when CATA attribute is not checked.
}
\examples{
data(bread)

# penalty lift, based only on the first 12 consumers

# for the first attribute ("Fresh")
pLift(bread$cata[1:12,,1], bread$liking[1:12, ]) 

# for the first 3  attributes
pLift(bread$cata[1:12,,1:3], bread$liking[1:12, ]) 
}
\references{
Meyners, M., Castura, J.C., & Carr, B.T. (2013). Existing and new 
approaches for the analysis of CATA data. \emph{Food Quality and Preference}, 
30, 309-319, \doi{10.1016/j.foodqual.2013.06.010}
}
