% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{expectedPV}
\alias{expectedPV}
\title{Expected Posterior Variance}
\usage{
expectedPV(catObj, item)
}
\arguments{
\item{catObj}{An object of class \code{Cat}}

\item{item}{An integer indicating the index of the question item}
}
\value{
The function \code{expectedPV} returns a numeric value indicating a respondent's expected posterior variance for an unasked item.
}
\description{
Estimates the expected posterior variance for a respondent's estimated ability parameter for an item yet to be answered based on a respondent's ability parameter estimate from the already-answered items.
}
\note{
This function is to allow users to access the internal functions of the package. During item selection, all calculations are done in compiled \code{C++} code.
}
\examples{
## Loading ltm Cat object
data(ltm_cat)

## Store example answers
setAnswers(ltm_cat) <- c(1,0,1,0,1, rep(NA, 35))

## Estimate EPV for different unasked items
expectedPV(ltm_cat, item = 10)
expectedPV(ltm_cat, item = 20)
expectedPV(ltm_cat, item = 30)


}
\seealso{
\code{\link{estimateSE}}, \code{\link{probability}}, \code{\link{selectItem}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery,
 Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
