% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carx_fitted.R
\name{fitted.carx}
\alias{fitted.carx}
\title{Fitted values of a \code{carx} object}
\usage{
\method{fitted}{carx}(object, ...)
}
\arguments{
\item{object}{a fitted \code{carx} object.}

\item{...}{not used.}
}
\value{
the fitted values.
}
\description{
Compute the fitted values from a \code{carx} object.
Note that the existence of censoring invalidates the usual Markov property for an AR model.
Instead, the conditional distribution of \eqn{Y^*_t} given the past \eqn{Y}s and current
and past covariates is the same as the conditional distribution
\eqn{D_t = D(Y^*_t|X_t, {(Y_{j}, X_j )}_{j=\tau}^{t-1} )},
where \eqn{1 \le \tau \le t-p} is the largest integer \eqn{t} such that
none of \eqn{Y_t;t=\tau+p-1,...,\tau} is censored. In the case that \eqn{\tau = t-p},
the fitted value can be readily computed; otherwise, the fitted value is computed as the
mean of the distribution
\eqn{D_t} by the function \code{mtmvnorm} from the package \pkg{{tmvtnorm}}.
}
\examples{
dat = carxSim(nObs=100,seed=0)
mdl <- carx(y~X1+X2-1,data=dat, p=2, CI.compute = FALSE)
#compute the fitted values
fv = fitted(mdl)
}
