% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/north.R
\name{north}
\alias{north}
\title{North Arrow}
\usage{
north(pos = "topright", col = "grey20", south = FALSE, x = NULL)
}
\arguments{
\item{pos}{position of the north arrow. It can be one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a 
vector of two coordinates in map units (c(x, y)).}

\item{col}{arrow color.}

\item{south}{plot a south arrow instead.}

\item{x}{sf or sp object used to correct the north azimuth}
}
\description{
Plot a north arrow.
}
\examples{
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
plot(st_geometry(mtq))
box()
for (i in list("topleft", "top", "topright", "right", "bottomright", 
               "bottom", "bottomleft", "left", c(746368, 1632993))){
  north(i, south = TRUE)
}
}
\seealso{
\link{layoutLayer}
}
