% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legendHatched.R
\name{legendHatched}
\alias{legendHatched}
\title{Legend for Hatched Maps}
\usage{
legendHatched(
  pos = "topleft",
  title.txt = "Title of the legend",
  title.cex = 0.8,
  values.cex = 0.6,
  categ,
  patterns,
  ptrn.bg = "white",
  ptrn.text = "X",
  dot.cex = 0.5,
  text.cex = 0.5,
  cex = 1,
  frame = FALSE,
  ...
)
}
\arguments{
\item{pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", 
"bottomleftextra", "left" or a vector of two coordinates in map units 
(c(x, y)).}

\item{title.txt}{title of the legend.}

\item{title.cex}{size of the legend title.}

\item{values.cex}{size of the values in the legend.}

\item{categ}{vector of categories.}

\item{patterns}{vector of patterns to be created for each element on \code{categ}, see \link{hatchedLayer}.}

\item{ptrn.bg}{background of the legend box for each \code{categ}.}

\item{ptrn.text}{text to be used for each \code{categ="text"}, as a single value or a vector.}

\item{dot.cex}{cex of each \code{patterns = "dot"} categories, as a single value or a vector.}

\item{text.cex}{text size of each \code{patterns = "text"} categories, as a single value or a vector.}

\item{cex}{size of the legend. 2 means two times bigger.}

\item{frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{...}{optional graphical parameters, see details on \link{hatchedLayer}}
}
\description{
Plot legend for hatched maps.
}
\note{
It is also possible to create solid legends, by setting \code{col} and \code{ptrn.bg} to the same color. 
Parameters would honour the order of the \code{categ} variable.
}
\examples{
library(sf)
mtq <-  st_read(system.file("gpkg/mtq.gpkg",
                            package = "cartography"),
                stringsAsFactors = FALSE)

breaksMED<-getBreaks(mtq$MED, nclass=3)
ord=unique(mtq$STATUS)
ord<-ord[c(2,3,1)]
typoLayer(mtq,  var = "STATUS",  legend.pos = "n",
          legend.values.order = ord,
          col = c("grey10", "grey50", "grey80"),border = NA)

mtq$Patts = cut(mtq$MED,c(-Inf,14000,18000,Inf), labels=FALSE)
hatchedLayer( mtq[mtq$Patts == 1,],"left2right",
              density = 2,  col = "white",  add = TRUE,  pch = 3,  cex = 0.6)
hatchedLayer(mtq[mtq$Patts == 2, ],"left2right",
             density = 4, col = "white", add = TRUE)
hatchedLayer(mtq[mtq$Patts == 3, ], "left2right", col = "white",
             add = TRUE, density = 6)

legendHatched(pos = "bottomleft",
              cex = 1.5,
              values.cex = 0.8,
              title.txt = "Median Income\n(in thousand of euros)",
              categ = c("< 14","14 - 18",">18",
                        "Prefecture", "Sub-prefecture",
                        "Simple municipality"),
              patterns = c("left2right"), density = c(1, 2, 3),
              col = c(rep("black", 3), "grey10", "grey50", "grey80"),
              ptrn.bg = c(rep("white", 3), "grey10", "grey50", "grey80"),
              pch = 3)
plot(st_geometry(st_union(mtq)), add = TRUE)
}
\seealso{
\link{hatchedLayer}, \link{legendTypo}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
