% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gradLinkLayer.R
\name{gradLinkLayer}
\alias{gradLinkLayer}
\title{Graduated Links Layer}
\usage{
gradLinkLayer(spdf, df, spdfid = NULL, spdfids, spdfide, dfid = NULL, dfids,
  dfide, var, breaks = discretization(v = df[, var], nclass = 4, method =
  "quantile"), lwd = c(1, 2, 4, 6), col = "red",
  legend.pos = "bottomleft", legend.title.txt = var,
  legend.title.cex = 0.8, legend.values.cex = 0.6, legend.values.rnd = 0,
  legend.frame = FALSE, add = TRUE)
}
\arguments{
\item{spdf}{SpatialLinesDataFrame; a link layer.}

\item{df}{data frame with identifier(s) and a variable.}

\item{spdfid}{unique identifier in spdf (spdfids, spdfide, dfids and dfide are not used).}

\item{spdfids}{identifier of starting points in spdf (spdfid and dfid are not used).}

\item{spdfide}{identifier of ending points in spdf (spdfid and dfid are not used).}

\item{dfid}{unique identifier in df (spdfids, spdfide, dfids and dfide are not used).}

\item{dfids}{identifier of starting points in df (spdfid and dfid are not used).}

\item{dfide}{identifier of ending points in df (spdfid and dfid are not used).}

\item{var}{name of the variable used to plot the links widths.}

\item{breaks}{break values in sorted order to indicate the intervals for assigning the lines widths.}

\item{lwd}{vector of widths (classes of widths).}

\item{col}{color of the links.}

\item{legend.pos}{position of the legend, one of "topleft", "top",
"topright", "left", "right", "bottomleft", "bottom", "bottomright". If
legend.pos is "n" then the legend is not plotted.}

\item{legend.title.txt}{title of the legend.}

\item{legend.title.cex}{size of the legend title.}

\item{legend.values.cex}{size of the values in the legend.}

\item{legend.values.rnd}{number of decimal places of the values
displayed in the legend.}

\item{legend.frame}{whether to add a frame to the legend (TRUE) or
not (FALSE).}

\item{add}{whether to add the layer to an existing plot (TRUE) or
not (FALSE).}
}
\description{
Plot a layer of graduated links. Links are plotted according to discrete classes of widths.
}
\note{
Unlike most of cartography functions, identifiers fields are mandatory.
}
\examples{
data("nuts2006")
# Create a link layer
twincities.spdf <- getLinkLayer(spdf = nuts2.spdf, df = twincities[,1:2])
# Plot the links - Twin cities agreements between regions
plot(nuts0.spdf, col = "grey60",border = "grey20")
gradLinkLayer(spdf = twincities.spdf, df = twincities,
              spdfids = "i", spdfide = "j",
              dfids = "i", dfide = "j",legend.pos = "topright",
              var = "fij", breaks = c(2,5,15,20,30), lwd = c(0.1,1,4,10),
              col = "#92000090", add = TRUE)
}
\seealso{
\link{getLinkLayer}, \link{propLinkLayer}, \link{legendGradLines}
}

