% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowtype.R
\name{flowtype}
\alias{flowtype}
\title{Compute bilateral several flow types}
\usage{
flowtype(
  tab,
  origin = NULL,
  destination = NULL,
  fij = NULL,
  format,
  lowup,
  net,
  x
)
}
\arguments{
\item{tab}{is the input flow dataset}

\item{origin}{the place of origin code}

\item{destination}{the place of destination code}

\item{fij}{the flow value between origin and destination places}

\item{format}{specify the flow dataset format, "M " for square matrix [n*n] or L for long [i,j,data]}

\item{lowup}{for extracting the lower or upper triangular sub-portion of the bilateral volum matrix. See Details.}

\item{net}{for extracting the "positive" or the "negative" flow values of the bilateral balance) matrix}

\item{x}{enter the flow indicator type : "alltypes", "flux", "transpose", "bivolum", "bibal","biasym","bimin", "bimax","birange" and "bidisym"}
}
\description{
Compute bilateral flow type: volumn (gross), balance (net), asymetry, min/max ... from an initial asymetric matrix
}
\details{
The matrice must be squared (if not, see \link{flowcarre}).
This function compute for all pairs or origin-destination places (i,j)
involved in an asymetric flow matrix (Fij<> Fji) several matrix :\cr
Param x:
- x = "flux" for the initial flow: (Fij)\cr
- x = "transpose" for the reverse flow value: (Fji) =t(Fij)\cr
- x = "bivolum" for the bilateral volum or gross flow: FSij=(Fij+Fji)\cr
- x = "bibal" for the bilateral balance or net flow: FBij=(Fij-Fji) \cr
- x = "biasym" for asymetry of bilateral flow: FAij=(FBij/FSij)\cr
- x = "bimin" for the minimum of bilateral flow: minFij=(Fij, Fji)\cr
- x = "bimax" for the maximum of bilateral flow: Fij(Fij, Fji)\cr
- x = "birange" for the amplitude of bilateral flows: rangeFij=(maxFij - minFij)\cr
- x = "bidisym" for the bilateral disymetry: FDij=(rangeFij/FSij)
- x = "alltypes" for computing all the available types of flows \cr
Param lowup is for reducing the matrix:\cr
- lowup ="up" for triangular part above the main diagonal \cr
- lowup = "low" for triangular part below the main diagonal\cr
Param net is for extracting positive or negative flow values of the bilateral balance (bibal matrix):\cr 
- net ="negative" values\cr
- net ="positive" values\cr
}
\examples{
library(cartograflow)
data(flowdata)
bkg <- system.file("shape/MGP_TER.shp",
  package = "cartograflow",
  lib.loc = NULL, mustWork = TRUE
)

## 1a:Computes flowtypes: Matrix format
matflow <- flowtabmat(flows, matlist = "M")
m <- flowtype(matflow, format = "M", x = "flux")
m <- flowtype(matflow, format = "M", x = "transpose")
m <- flowtype(matflow, format = "M", x = "bivolum")
m <- flowtype(matflow, format = "M", x = "bibal")

## 1b:Computes flowtypes: Long format
types_all <- flowtype(flows,origin ="i",destination="j",fij="Fij", format = "L",
x = "alltypes")
bivol<- flowtype(flows,origin ="i",destination="j",fij="Fij",format = "L",
x = "bivolum",lowup="up")
bibal_net<- flowtype(flows,origin ="i",destination="j",fij="Fij",format = "L",
x = "bibal", net="negative")
\donttest{
# 2:flowmapping: example of bibal_net
flowmap(bibal_net,
  format = "L", bkg, code = "EPT_NUM",
  filter = TRUE, threshold = 20, taille = 5, a.head = 1,
)
}
}
\references{
Bahoken Francoise, 2016, L'approche cartographique de la décomposition des matrices de flux,
Mappemonde, Revue sur l'image géographique et les formes du territoire,
number 116, URL : https://mappemonde-archive.mgm.fr/num44/articles/art14404.html
}
