% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowanalysis.R
\name{flowanalysis}
\alias{flowanalysis}
\title{Computation of a global concentration criterion of flows values or features}
\usage{
flowanalysis(tab, critflow, critlink, result)
}
\arguments{
\item{tab}{flow dataset from \link{flowgini}}

\item{critflow}{level of flow significativity. See Details.}

\item{critlink}{level of features density. See Details.}

\item{result}{resulting filtering criterion value. See Details.}
}
\description{
\code{Computation of a global selection criterion for thresholding flow information and/or features before mapping.}\cr
To be use after \link{flowgini} and before \link{flowmap}.
}
\details{
-critflow =  desired level of flow's information significativity (e.g. 80%)
 of the total information ;\cr
-critlink = desired level of flow's features density (e.g. 20%) of the flow
       features that represents "more significant information.

-result="density" returns the desired level of features density as
       a % of total features ;\cr
-result = "significativity" returns the level of flow significativity as a
       % of total of flow information ;
}
\examples{
library(cartograflow)
data(flowdata)
bkg<- system.file("shape/MGP_TER.shp", package="cartograflow",
                  lib.loc = NULL, mustWork = TRUE)

#1/4: Computes Gini's coefficent
tab_gini<-flowgini(flows,format="L",origin="i",dest="j",valflow="Fij",
          bkg,code="EPT_NUM",lorenz.plot = FALSE)
### [1] Gini's coefficent = 73.16 \%
\donttest{
#2/4: Plot Lorenz curve
flowgini(tab_gini,format="L",origin="i",dest="j",valflow="ydata",
          bkg,code="EPT_NUM",lorenz.plot = TRUE)
}
#3/4: Compute critflow filtering parameter
#critflow = 0.8 #selected criterion
flowanalysis(tab_gini,critflow = 0.8,result = "signif")
### [1] "threshold =  11238  ---  flows =  80 \% ---  links =  22.94 \%"

#4/4: Plot the flowmap
\donttest{
flowmap(flows,format="L",bkg,code = "EPT_NUM",filter = TRUE,
         threshold = 11238,taille = 8,a.head = 1,a.length = 0.11,
         a.angle = 30,a.col="#3f4247")}

}
\references{
Bahoken Françoise, 2016,« La cartographie d’une sélection globale de flux, entre ‘significativité’ et ‘densité’ »,
Netcom Online, 30-3/4 | 2016, Online since 23 March 2017, connection on 05 May 2019. URL : http://journals.openedition.org/netcom/2565 ;
DOI : 10.4000/netcom.2565
}
