% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_table.R
\name{build_table}
\alias{build_table}
\title{Build the final table.}
\usage{
build_table(data, caption = NULL, style = "rmarkdown", split = Inf,
  missing = "", alignment = "center", finish = TRUE)
}
\arguments{
\item{data}{The draft table object.}

\item{caption}{Table caption.}

\item{style}{What output style (rmarkdown, grid, simple, etc) should the
table be.}

\item{split}{When should the table split when it is too wide? (Inf means never).}

\item{missing}{How to deal with missing values in the table (removed by default).}

\item{alignment}{Table column alignment.}

\item{finish}{Generate the final table in markdown formatted form.}
}
\value{
Creates a \code{\link[pander]{pander}} created table.
}
\description{
Output can be to common formats such as rmarkdown, html, etc, based on the
\code{style} argument of the \code{\link[pander]{pander}} function.
}
\seealso{
\code{\link{carpenter}} for a list of all functions, examples, and
  accessing the introduction tutorial vignette.
}

