% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_stats_oneway_test.R
\name{ard_stats_oneway_test}
\alias{ard_stats_oneway_test}
\title{ARD One-way Test}
\usage{
ard_stats_oneway_test(formula, data, ...)
}
\arguments{
\item{formula}{a formula of the form \code{lhs ~ rhs} where \code{lhs}
    gives the sample values and \code{rhs} the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
    \code{\link[stats]{model.frame}}) containing the variables in the
    formula \code{formula}.  By default the variables are taken from
    \code{environment(formula)}.}

\item{...}{additional arguments passed to \code{oneway.test(...)}}
}
\value{
ARD data frame
}
\description{
Analysis results data for Testing Equal Means in a One-Way Layout.
calculated with \code{oneway.test()}
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "broom", reference_pkg = "cardx"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ard_stats_oneway_test(AGE ~ ARM, data = cards::ADSL)
\dontshow{\}) # examplesIf}
}
