% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_emmeans_mean_difference.R
\name{ard_emmeans_mean_difference}
\alias{ard_emmeans_mean_difference}
\title{ARD for LS Mean Difference}
\usage{
ard_emmeans_mean_difference(
  data,
  formula,
  method,
  method.args = list(),
  package = "base",
  response_type = c("continuous", "dichotomous"),
  conf.level = 0.95,
  primary_covariate = getElement(attr(stats::terms(formula), "term.labels"), 1L)
)
}
\arguments{
\item{data}{(\code{data.frame}/\code{survey.design})\cr
a data frame or survey design object}

\item{formula}{(\code{formula})\cr
a formula}

\item{method}{(\code{string})\cr
string of function naming the function to be called, e.g. \code{"glm"}.
If function belongs to a library that is not attached, the package name
must be specified in the \code{package} argument.}

\item{method.args}{(named \code{list})\cr
named list of arguments that will be passed to \code{method}.

Note that this list may contain non-standard evaluation components.
If you are wrapping this function in other functions, the argument
must be passed in a way that does not evaluate the list, e.g.
using rlang's  embrace operator \code{{{ . }}}.}

\item{package}{(\code{string})\cr
string of package name that will be temporarily loaded when function
specified in \code{method} is executed.}

\item{response_type}{(\code{string})
string indicating whether the model outcome is \code{'continuous'}
or \code{'dichotomous'}. When \code{'dichotomous'}, the call to \code{emmeans::emmeans()} is
supplemented with argument \code{regrid="response"}.}

\item{conf.level}{(scalar \code{numeric})\cr
confidence level for confidence interval. Default is \code{0.95}.}

\item{primary_covariate}{(\code{string})\cr
string indicating the primary covariate (typically the dichotomous treatment variable).
Default is the first covariate listed in the formula.}
}
\value{
ARD data frame
}
\description{
This function calculates least-squares mean differences using the 'emmeans'
package using the following

\if{html}{\out{<div class="sourceCode r">}}\preformatted{emmeans::emmeans(object = <regression model>, specs = ~ <primary covariate>) |>
  emmeans::contrast(method = "pairwise") |>
  summary(infer = TRUE, level = <confidence level>)
}\if{html}{\out{</div>}}

The arguments \code{data}, \code{formula}, \code{method}, \code{method.args}, \code{package} are used
to construct the regression model via \code{cardx::construct_model()}.
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "emmeans", reference_pkg = "cardx"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ard_emmeans_mean_difference(
  data = mtcars,
  formula = mpg ~ am + cyl,
  method = "lm"
)

ard_emmeans_mean_difference(
  data = mtcars,
  formula = vs ~ am + mpg,
  method = "glm",
  method.args = list(family = binomial),
  response_type = "dichotomous"
)
\dontshow{\}) # examplesIf}
}
