% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{one_grid_bkg}
\alias{one_grid_bkg}
\title{Generate One Grid with Different Values and Background Noise}
\usage{
one_grid_bkg(n_value, num_noise, min_n, max_n)
}
\arguments{
\item{n_value}{The number of grid points along each axis for the grids.}

\item{num_noise}{The number of additional noise dimensions to add to the data.}

\item{min_n}{The minimum value for the noise dimensions.}

\item{max_n}{The maximum value for the noise dimensions.}
}
\value{
A list containing the one grid datasets with background noise and the sample size.
}
\description{
This function generates a grid dataset with different values and background noise.
}
\examples{
set.seed(20240412)
one_grid_bkg <- one_grid_bkg(
  n_value = 10, num_noise = 2, min_n = -0.05,
  max_n = 0.05
)
}
