% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_scope3_emissions.R
\name{plot_scope3_emissions}
\alias{plot_scope3_emissions}
\title{Plot Scope 3 Emissions Breakdown}
\usage{
plot_scope3_emissions(scope3_df, company_name = NULL)
}
\arguments{
\item{scope3_df}{Data frame output from sme_scope3 (must contain 'Category', 'Description', and 'Predicted Emissions (tCO2e)').}

\item{company_name}{Optional company name to include in the chart title (character string).}
}
\value{
A Sankey plot showing a breakdown for predicted emissions of each Scope 3 category.
}
\description{
Plots a Sankey diagram showing the breakdown of Scope 3 emissions by category.
}
\examples{
scope3_df <- sme_scope3(85, 12000000)
plot_scope3_emissions(scope3_df, company_name = "Carbon Predict LTD")
}
