% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotGelmanRubin.R
\name{PlotGelmanRubinDiagnosticMultiChain}
\alias{PlotGelmanRubinDiagnosticMultiChain}
\title{Plot Histogram of the Gelman-Rubin Convergence Diagnostic for Multiple Independent
MCMC Chains}
\usage{
PlotGelmanRubinDiagnosticMultiChain(output_data_list, n_burn = NA)
}
\arguments{
\item{output_data_list}{A list, each item containing the return value from one of the updating
functions e.g. \link{PolyaUrnBivarDirichlet}, \link{WalkerBivarDirichlet} or
\link{PPcalibrate}. The minimum number of elements in the list is 2.}

\item{n_burn}{The number of MCMC iterations that should be discarded for burn-in. This relates to
the total number of iterations \code{n_iter} when running the original update functions (not the
thinned \code{output_data}). Any MCMC iterations before this are not used in the calculations of the PSRF.
If not given, the first half of the MCMC chain is discarded. Note: The maximum value that the function
will allow is \code{n_iter - 100 * n_thin} (where \code{n_iter} and \code{n_thin} are the arguments that were given to
\link{PPcalibrate}) which would leave only 100 of the (thinned) values in \code{output_data}.}
}
\value{
None
}
\description{
This plots a histogram of the potential scale reduction factors (PSRF) for each of the individual
posterior calendar age estimates for multiple independent MCMC chains. Achieved by comparing the
\emph{within-chain} variance with the \emph{between-chains} variance after \code{n_burn} iterations.
The PSRF of each sample's posterior calendar age is calculated.
If the chain have converged to the target posterior distribution, then PSRF should
be close to 1 for all of the samples (a stringent condition is that all values are less than 1.1).

For more information read the vignette: \cr
\code{vignette("determining-convergence", package = "carbondate")}
}
\examples{
# Plot results for the example data - n_iter is too small for convergence
# Try increasing n_iter to see the values of the PSRF decrease
po <- list()
for (i in 1:3) {
    set.seed(i)
    po[[i]] <- PolyaUrnBivarDirichlet(
        two_normals$c14_age,
        two_normals$c14_sig,
        intcal20,
        n_iter=400,
        show_progress = FALSE)
}
PlotGelmanRubinDiagnosticMultiChain(po)
}
