% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InterpolateCalibrationCurve.R
\name{InterpolateCalibrationCurve}
\alias{InterpolateCalibrationCurve}
\title{Interpolate a calibration curve at a set of calendar ages}
\usage{
InterpolateCalibrationCurve(
  new_calendar_ages_BP,
  calibration_curve,
  F14C_outputs = NA
)
}
\arguments{
\item{new_calendar_ages_BP}{A scalar or vector containing calendar ages (in cal yr BP) at
which to interpolate the values (both the means and uncertainties) of the given calibration curve.
If not provided (and \code{NA} is given), will use the range from the minimum calendar age to the maximum calendar age
of the original calibration curve spaced by 1.}

\item{calibration_curve}{A dataframe which must contain one column \code{calendar_age_BP}, and also
columns \code{c14_age} and \code{c14_sig} or \code{f14c} and \code{f14c_sig} (or both sets).
This format matches the curves supplied with this package, e.g., \link{intcal20},
\link{intcal13}, which contain all 5 columns.}

\item{F14C_outputs}{\code{TRUE} if only F\eqn{{}^{14}}C concentrations are required, \code{FALSE}
if only the radiocarbon ages (in \eqn{{}^{14}}C yrs BP) are required and \code{NA} if both are required for the new curve.}
}
\value{
A new dataframe with entries for the interpolated \code{c14_age}, and
\code{c14_sig}, \code{f14c} and \code{f14c_sig} values at the \code{calendar_age_BP} values that were
given in \code{new_calendar_ages_BP}.
}
\description{
Interpolate a calibration curve at a set of calendar ages
}
\examples{

# Interpolate intcal20 at a single calendar age. Generates both 14C ages and F14C scales.
InterpolateCalibrationCurve(51020, intcal20)

# Interpolate intcal20 at two calendar ages. Generates F14C estimates only.
InterpolateCalibrationCurve(c(51017, 51021), intcal20, TRUE)

# Interpolate intcal20 at two calendar ages. Generate 14C age estimates (cal yr BP) only.
InterpolateCalibrationCurve(c(51017, 51021), intcal20, FALSE)

# Interpolate intcal20 at every integer calendar age within the range of dates
# (for intcal20 this is 0 to 55000 cal yr BP), and create estimates for both radiocarbon scales.
cal_curve <- InterpolateCalibrationCurve(NA, intcal20)
}
