\name{DoptBCD.sim}
\alias{DoptBCD.sim}
\alias{DoptBCD.sim.carandom}
\title{
Atkinson's \eqn{D_A}-optimal Biased Coin Design for Simulated Data
}
\description{
Allocates patients generated by simulating covariates-profile on assumption of independence between covariates and levels within each covariate, to one of two treatments based on \eqn{D_A}-optimal biased coin design in the presence of the prognostic factors proposed by Atkinson A C (1982) <Doi:10.2307/2335853>.
}
\usage{
\method{DoptBCD.sim}{carandom}(n = 1000, cov_num = 2, level_num = c(2, 2), 
            pr = rep(0.5, 4))
}
\arguments{
  \item{n}{number of patients. Default is \code{1000}.}
  \item{cov_num}{number of covariates. Default is \code{2}.}
  \item{level_num}{vector of level numbers for each covariates. Hence the length of level_num should equal to number of covariates. Default is \code{level_num = c(2, 2)}. }
  \item{pr}{vector of probabilities. Under assumption of independence between covariates, \code{pr} is a vector containing probabilities for each levels of each covariates. The length of \code{pr} should correspond to number of all levels; and sum of \code{pr} should equal \code{cov_num}. If \code{pr = rep(0.5, 4)} (default), it means \code{cov_num = 2}, and \code{level_num = c(2, 2)}.}
}
\details{
See \code{\link{DoptBCD}}.
}
\value{
See \code{\link{DoptBCD}}. 
}
\seealso{
See \code{\link{DoptBCD}} for allocating a given completely collected data; See \code{\link{DoptBCD.ui}} for command-line user interface. 
}