% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{print.caracas_solve_sys_sol}
\alias{print.caracas_solve_sys_sol}
\title{Print solution}
\usage{
\method{print}{caracas_solve_sys_sol}(
  x,
  simplify = getOption("caracas.print.sol.simplify", default = TRUE),
  ...
)
}
\arguments{
\item{x}{A \code{caracas_symbol}}

\item{simplify}{Print solution in a simple format}

\item{\dots}{Passed to \code{\link[=print.caracas_symbol]{print.caracas_symbol()}}}
}
\description{
Print solution
}
\examples{
if (has_sympy()) {
  x <- symbol('x')
  solve_sys(x^2, -1, x)
  
  y <- symbol("y")
  lhs <- cbind(3*x*y - y, x)
  rhs <- cbind(-5*x, y+4)
  sol <- solve_sys(lhs, rhs, list(x, y))
  sol
}

}
\concept{output}
