% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feglm.R
\name{feglm}
\alias{feglm}
\title{GLM fitting with high-dimensional k-way fixed effects}
\usage{
feglm(
  formula = NULL,
  data = NULL,
  family = gaussian(),
  weights = NULL,
  beta_start = NULL,
  eta_start = NULL,
  control = NULL
)
}
\arguments{
\item{formula}{an object of class \code{"formula"}: a symbolic description of
the model to be fitted. \code{formula} must be of type \code{y ~ x | k},
where the second part of the formula refers to factors to be concentrated
out. It is also possible to pass clustering variables to \code{\link{feglm}}
as \code{y ~ x | k | c}.}

\item{data}{an object of class \code{"data.frame"} containing the variables
in the model. The expected input is a dataset with the variables specified
in \code{formula} and a number of rows at least equal to the number of
variables in the model.}

\item{family}{the link function to be used in the model. Similar to
\code{\link[stats]{glm.fit}} this has to be the result of a call to a family
function. Default is \code{gaussian()}. See \code{\link[stats]{family}} for
details of family functions.}

\item{weights}{an optional string with the name of the 'prior weights'
variable in \code{data}.}

\item{beta_start}{an optional vector of starting values for the structural
parameters in the linear predictor. Default is
\eqn{\boldsymbol{\beta} = \mathbf{0}}{\beta = 0}.}

\item{eta_start}{an optional vector of starting values for the linear
predictor.}

\item{control}{a named list of parameters for controlling the fitting
process. See \code{\link{feglm_control}} for details.}
}
\value{
A named list of class \code{"feglm"}. The list contains the following
fifteen elements:
\item{coefficients}{a named vector of the estimated coefficients}
\item{eta}{a vector of the linear predictor}
\item{weights}{a vector of the weights used in the estimation}
\item{hessian}{a matrix with the numerical second derivatives}
\item{deviance}{the deviance of the model}
\item{null_deviance}{the null deviance of the model}
\item{conv}{a logical indicating whether the model converged}
\item{iter}{the number of iterations needed to converge}
\item{nobs}{a named vector with the number of observations used in the
estimation indicating the dropped and perfectly predicted observations}
\item{lvls_k}{a named vector with the number of levels in each fixed
effects}
\item{nms_fe}{a list with the names of the fixed effects variables}
\item{formula}{the formula used in the model}
\item{data}{the data used in the model after dropping non-contributing
observations}
\item{family}{the family used in the model}
\item{control}{the control list used in the model}
}
\description{
\code{\link{feglm}} can be used to fit generalized linear models
with many high-dimensional fixed effects. The estimation procedure is based
on unconditional maximum likelihood and can be interpreted as a
\dQuote{weighted demeaning} approach.

\strong{Remark:} The term fixed effect is used in econometrician's sense of
having intercepts for each level in each category.
}
\details{
If \code{\link{feglm}} does not converge this is often a sign of
linear dependence between one or more regressors and a fixed effects
category. In this case, you should carefully inspect your model
specification.
}
\examples{
mod <- feglm(mpg ~ wt | cyl, mtcars, family = poisson(link = "log"))
summary(mod)

mod <- feglm(mpg ~ wt | cyl | am, mtcars, family = poisson(link = "log"))
summary(mod, type = "clustered")

}
\references{
Gaure, S. (2013). "OLS with Multiple High Dimensional Category
Variables". Computational Statistics and Data Analysis, 66.

Marschner, I. (2011). "glm2: Fitting generalized linear models
with convergence problems". The R Journal, 3(2).

Stammann, A., F. Heiss, and D. McFadden (2016). "Estimating Fixed
Effects Logit Models with Large Panel Data". Working paper.

Stammann, A. (2018). "Fast and Feasible Estimation of Generalized
Linear Models with High-Dimensional k-Way Fixed Effects". ArXiv e-prints.
}
