% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily_behaviour.R
\name{get_step_score}
\alias{get_step_score}
\title{Compute a step score.}
\usage{
get_step_score(step_average = NA)
}
\arguments{
\item{step_average}{A numeric vector representing average daily steps taken. See \code{\link[=get_step_average]{get_step_average()}}.}
}
\value{
Returns a numeric (integer) vector with values between 0 and 25 (if valid) or NA (if not valid).
}
\description{
This function computes a step score (\code{step_score}) based on the average daily steps taken as measured by a pedometer. This score is used to compute the
daily behaviour domain score (\code{db_score}).
}
\details{
Other \code{capl} functions called by this function include: \code{\link[=validate_number]{validate_number()}}.
}
\examples{
capl_demo_data <- get_capl_demo_data(10)

step_average <- get_step_average(capl_demo_data)$step_average

get_step_score(step_average)

# [1] 25 18 22 18 15 20 25 20 24 15

}
