% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_effects.R
\name{plot_effects}
\alias{plot_effects}
\title{Plot Interaction Effects}
\usage{
plot_effects(
  data_obj,
  geno_obj,
  marker1,
  marker2 = NULL,
  pheno_type = "normalized",
  plot_type = c("l", "p", "b", "h"),
  error_bars = "none",
  ymin = NULL,
  ymax = NULL,
  covar = NULL,
  marker1_label = NULL,
  marker2_label = NULL,
  bin_continuous_genotypes = TRUE,
  ref_centered = TRUE,
  gen_model = "Additive",
  bins_marker1 = 50,
  bins_marker2 = 50
)
}
\arguments{
\item{data_obj}{A \code{\link{Cape}} object}

\item{geno_obj}{A genotype object}

\item{marker1}{A string indicating the name 
of the source marker in the interaction. This can
also be the name of a covariate.}

\item{marker2}{Another string indicating the name 
of the source marker in the interaction. This can
also be the name of a covariate. Optional.}

\item{pheno_type}{One of "eigentraits", 
"normalized_traits", or "raw_traits", indicating which
traits to plot.}

\item{plot_type}{A letter referring to the desired style 
of the plot. The choices are the following: "l" - line plots,
"p" = points, "b" - bar plots, "h" - heat map.}

\item{error_bars}{The type of error bars to plot. Choices
are "none" (the default), "se" for standard error, or 
"sd" for standard deviation.}

\item{ymin}{A minimum value for the y axes across all plots.
If NULL, each y axis will be determined independently}

\item{ymax}{A maximum value for the y axes across all plots.
If NULL, each y axis will be dertermined independently}

\item{covar}{A vector of strings indicating which covariates,
if any, the traits should be adjusted for. If NULL, the 
covariates specified in the data_obj are used as default.
To prevent adjusting for covariates, use "none".}

\item{marker1_label}{A string to use as the label for marker1
If NULL, the string used for marker1 will be used.}

\item{marker2_label}{A string to use as the label for marker2
If NULL, the string used for marker2 will be used.}

\item{bin_continuous_genotypes}{If TRUE, genotypes (and covariate)
values will be binned into 0, 0.5, and 1 values. This 
reduces the number of bins that traits need to be divided 
into, especially if there are only one or two individuals
with a 0.49 genotype, for example. Binning may not be
desirable when using the heatmap.}

\item{ref_centered}{A logical value indicating whether 
to center the values on the reference allele. Defaults 
to TRUE.}

\item{gen_model}{One of "Additive", "Dominant", or "Recessive"
indicating how the genotypes should be coded. If Additive,
genotypes are coded as 0 for homozygous reference allele,
1 for homozygous alternate allele, and 0.5 for heterozygous.
If Dominant, any allele probability greater than 0.5 is 
set to 1. If recessive, any allele probability less than
or equal to 0.5 is set to 0. In other words, for the 
dominant coding, heterozygotes are grouped with the 
homozygous alternate genotypes: 0 vs. (0.5,1). This shows
the effect of having any dose of the alternate allele. With
a recessive coding, heterozygotes are grouped with the
homozygous reference genotypes: (0, 0.5) vs. 1. This shows
the effect of having two copies of the alternate allele 
vs. having fewer than two copies.}

\item{bins_marker1}{Only used for heatmap plotting. The 
number of bins for marker1 if it is a continuously valued 
marker or covariate. The bins are used to fit a linear 
model and predict outcomes for a 2D grid of marker1 and
marker2 values. This argument can also be a vector of
bin values for binning at specific values.}

\item{bins_marker2}{The same as bins_marker1, but for
marker2.}
}
\value{
None
}
\description{
This function plots phenotypic effects of 
individual cape interactions. It serves as
a wrapper for the functions \code{\link{plot_lines}}
\code{\link{plot_bars}} \code{\link{plot_points}},
and \code{\link{plot_int_heat}}. Each of those functions
plots individual cape interactions in different forms.
}
\details{
The "h" option calls \code{\link{plot_int_heat}}, which
fits linear models to each trait and both markers specified.
It uses those models to predict phenotype values along continuously
valued genotype bins and plots the predicted values as a heatmap.
}
\examples{
\dontrun{
marker1 <- dimnames(geno_obj)[[3]][1]
marker2 <- dimnames(geno_obj)[[3]][2]
plot_effects(data_obj, geno_obj, plot_type = "l", error_bars = "se")
}

}
