% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim.R
\name{get_cansim}
\alias{get_cansim}
\title{Retrieve a Statistics Canada data table using NDM catalogue number}
\usage{
get_cansim(
  cansimTableNumber,
  language = "english",
  refresh = FALSE,
  timeout = 200,
  factors = TRUE,
  default_month = "07",
  default_day = "01"
)
}
\arguments{
\item{cansimTableNumber}{the NDM table number to load}

\item{language}{\code{"en"} or \code{"english"} for English and \code{"fr"} or \code{"french"} for French language versions (defaults to English)}

\item{refresh}{(Optional) When set to \code{TRUE}, forces a reload of data table (default is \code{FALSE})}

\item{timeout}{(Optional) Timeout in seconds for downloading cansim table to work around scenarios where StatCan servers drop the network connection.}

\item{factors}{(Optional) Logical value indicating if dimensions should be converted to factors. (Default set to \code{TRUE}).}

\item{default_month}{The default month that should be used when creating Date objects for annual data (default set to "07")}

\item{default_day}{The default day of the month that should be used when creating Date objects for monthly data (default set to "01")
Set to higher values for large tables and slow network connection. (Default is \code{200}).}
}
\value{
A tibble with StatCan Table data and added \code{Date} column with inferred date objects and
added \code{val_norm} column with normalized value from the \code{VALUE} column.
}
\description{
Retrieves a data table using an NDM catalogue number as a tidy data frame. Retrieved table data is cached for the duration of the current R session only by default.
}
\examples{
\dontrun{
get_cansim("34-10-0013")
}
}
