% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim.R
\name{get_cansim_table_short_notes}
\alias{get_cansim_table_short_notes}
\title{Retrieve Statistics Canada data table short notes}
\usage{
get_cansim_table_short_notes(
  cansimTableNumber,
  language = "english",
  refresh = FALSE,
  timeout = 200
)
}
\arguments{
\item{cansimTableNumber}{the NDM table number to load}

\item{language}{\code{"en"} or \code{"english"} for English and \code{"fr"} or \code{"french"} for French language versions (default set to English)}

\item{refresh}{(Optional) When set to \code{TRUE}, forces a reload of data table (default is \code{FALSE})}

\item{timeout}{(Optional) Timeout in seconds for downloading cansim table to work around scenarios where StatCan servers drop the network connection.}
}
\value{
A tibble with the StatCan Notes for the table
}
\description{
Returns table notes given an NDM table number in English or French. Retrieved table information data is cached for the duration of the R session only.
}
\examples{
\donttest{
get_cansim_table_short_notes("34-10-0013")
}
}
