% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_sets_formatted.R
\name{get_data_sets_formatted}
\alias{get_data_sets_formatted}
\title{Retrieves Data Set Reporting Rate Metrics}
\usage{
get_data_sets_formatted(
  dataset_ids,
  start_date,
  end_date = NULL,
  level = c("country", "county", "subcounty", "ward", "facility"),
  organisations = NULL,
  ...
)
}
\arguments{
\item{dataset_ids}{A vector of data sets IDs for which to retrieve data. Required.}

\item{start_date}{The start date to retrieve data. It is required and in the format \code{YYYY-MM-dd}.}

\item{end_date}{The ending date for data retrieval (default is the current date).}

\item{level}{The desired data granularity: \code{"country"} (the default), \code{"county"}, \code{"subcounty"}, \code{"ward"}, or \code{"facility"}.}

\item{organisations}{A list of organization units ids to be filtered.}

\item{...}{Other options that can be passed onto KHIS API.}
}
\value{
A tibble with detailed information, including:
\itemize{
\item Geographical identifiers (country, county, subcounty, ward, facility, depending on level)
\item Reporting period (month, year, fiscal year)
\item The reporting metric can be REPORTING_RATE, REPORTING_RATE_ON_TIME, ACTUAL_REPORTS, ACTUAL_REPORTS_ON_TIME, EXPECTED_REPORTS.
}
}
\description{
\code{get_data_sets_formatted()} fetches the data set reporting metrics. The metric
can be REPORTING_RATE, REPORTING_RATE_ON_TIME, ACTUAL_REPORTS, ACTUAL_REPORTS_ON_TIME, EXPECTED_REPORTS.
}
\examples{
\dontshow{if (khis_has_cred()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# The MoH 745 Cancer Screening Program Monthly Summary Form
dataset_id = c('WWh5hbCmvND')

# Download data from February 2023 to current date
data <- get_data_sets_formatted(element_ids = element_id,
                                start_date = '2023-02-01')
data
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=get_organisation_units_metadata]{get_organisation_units_metadata()}} for getting the organisations units
\item \code{\link[=get_data_sets]{get_data_sets()}} for retrieving the data sets
}
}
