% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_suite.R
\name{get_statcan_geo_suite}
\alias{get_statcan_geo_suite}
\title{Read the geosuite data}
\usage{
get_statcan_geo_suite(level, census_year = "2021", refresh = FALSE)
}
\arguments{
\item{level}{geographic level to return the data for, valid choices are
"DB", "DA", "ADA", "CT", "CSD", "CMA", "CD", "PR", "FED", "DPL", "ER", "PN", "POPCTR"}

\item{census_year}{census year to get the data for, right now only 2021 is supported}

\item{refresh}{(logical) refresh the cache if true}
}
\value{
tibble with the geosuite data
}
\description{
Reads the geosuite data for the given level and census year. Data gets cached after first download if the
cancensus cache path has been set. For older
years `get_statcan_geographic_attributes()` can fill in most of the information
}
\examples{
# list add the cached census data
\dontrun{
get_statcan_geo_suite("DA","2021")
}
}
