% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/census_vectors.R
\name{search_census_vectors}
\alias{search_census_vectors}
\title{Query the CensusMapper API for vectors with descriptions matching a searchterm.}
\usage{
search_census_vectors(searchterm, dataset, type = NA, ...)
}
\arguments{
\item{searchterm}{The term to search for e.g. \code{"Ojibway"}.
Search terms are case insensitive. If unable to find a given search term,
this function will suggest the correct spelling to use when possible.}

\item{dataset}{The dataset to query for available vectors, e.g.
\code{"CA16"}.}

\item{type}{One of \code{NA}, \code{'Total'}, \code{'Male'} or \code{'Female'}.
If specified, only return variables of specified `type`.}

\item{...}{Further arguments passed on to \code{\link{list_census_vectors}}.}
}
\description{
Query the CensusMapper API for vectors with descriptions matching a searchterm.
}
\examples{
search_census_vectors('Ojibway', 'CA16')
\dontrun{
# This will return a warning that no match was found, but will suggest similar terms.
search_census_vectors('Ojibwe', 'CA16', 'Total')
}
}
