% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict,commOccu-method}
\alias{predict,commOccu-method}
\title{Spatial predictions from community occupancy models}
\usage{
\S4method{predict}{commOccu}(
  object,
  mcmc.list,
  type,
  draws = 1000,
  level = 0.95,
  interval = c("none", "confidence"),
  x,
  speciesSubset
)
}
\arguments{
\item{object}{\code{commOccu} object}

\item{mcmc.list}{mcmc.list. Output of \code{\link{fit}} called on a \code{commOccu} object}

\item{type}{character. "psi" for species occupancy estimates, "richness" for species richness estimates}

\item{draws}{Number of draws from the posterior to use when generating the plots. If fewer than draws are available, they are all used}

\item{level}{Probability mass to include in the uncertainty interval}

\item{interval}{# Type of interval calculation. Can be "none" or "confidence". Can be slow for type = "psi" with many cells and posterior samples. Can be abbreviated.}

\item{x}{raster stack or data.frame. Must be scaled with same parameters as site covariates used in model, and have same names.}

\item{speciesSubset}{species to include in richness estimates. Can be index number or species names.}
}
\value{
A raster stack or data.frame, depending on x
}
\description{
Create spatial predictions of species occupancy and species richness from community occupancy models and raster stacks.
}
