% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename-prefix.R
\name{rename_prefix}
\alias{rename_prefix}
\title{Convert data frame name suffixes to prefixes}
\usage{
rename_prefix(df, suffix = c(".x", ".y"), punct = TRUE)
}
\arguments{
\item{df}{A joined data frame.}

\item{suffix}{If there are non-joined duplicate variables in x and y, these
suffixes will be added to the output to disambiguate them. Should be a
character vector of length 2. Will be converted to prefixes.}

\item{punct}{logical; Should punctuation at the start of the suffix be
detected and placed at the end of the new prefix? \code{TRUE} by default.}
}
\value{
A data frame with new column names.
}
\description{
When performing a \code{\link[dplyr:mutate-joins]{dplyr::left_join()}}, the \code{suffix} argument allows the user
to replace the default \code{.x} and \code{.y} that are appended to column names shared
between the two data frames. This function allows a user to convert those
suffixes to \emph{prefixes}.
}
\examples{
a <- data.frame(x = letters[1:3], y = 1:3)
b <- data.frame(x = letters[1:3], y = 4:6)
df <- dplyr::left_join(a, b, by = "x", suffix = c(".a", ".b"))
rename_prefix(df, suffix = c(".a", ".b"), punct = TRUE)
}
