% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counters.R
\name{which_out}
\alias{which_out}
\title{Which out}
\usage{
which_out(x, y, na.rm = TRUE, ignore.case = FALSE)
}
\arguments{
\item{x}{A vector to check.}

\item{y}{A vector to compare against.}

\item{na.rm}{logical; Should \code{NA} be ignored?}

\item{ignore.case}{logical; if \code{FALSE}, the pattern matching is case
sensitive and if \code{TRUE}, case is ignored during matching.}
}
\value{
The elements of \code{x} that are \verb{\%out\%} y.
}
\description{
Return the values of \code{x} that are \verb{\%out\%} of the vector \code{y}.
}
\details{
\code{x[which(x \%out\% y)]}
}
\examples{
which_out(c("VT", "DC", NA), state.abb)
}
\seealso{
Other counting wrappers: 
\code{\link{count_diff}()},
\code{\link{count_in}()},
\code{\link{count_na}()},
\code{\link{count_out}()},
\code{\link{count_vec}()},
\code{\link{na_in}()},
\code{\link{na_out}()},
\code{\link{na_rep}()},
\code{\link{prop_distinct}()},
\code{\link{prop_in}()},
\code{\link{prop_na}()},
\code{\link{prop_out}()},
\code{\link{which_in}()}
}
\concept{counting wrappers}
