## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(callback)
data(inter1)
str(inter1)

## -----------------------------------------------------------------------------
levels(inter1$gender)
levels(inter1$origin)

## -----------------------------------------------------------------------------
m <- callback(data = inter1, cluster = "offer", candid = c("gender","origin"), callback = "callback")

## -----------------------------------------------------------------------------
print(m)

## -----------------------------------------------------------------------------
print(stat_glob(m))

## ----fig.width=7,fig.height=4.4-----------------------------------------------
graph(stat_glob(m))

## ----fig.width=7,fig.height=4.4-----------------------------------------------
s <- stat_glob(m,level=0.9)
print(s,method="cp")
graph(s,method="cp",col="steelblue3")

## -----------------------------------------------------------------------------
s <- stat_count(m)

## -----------------------------------------------------------------------------
print(s)

## -----------------------------------------------------------------------------
s$props

## -----------------------------------------------------------------------------
stat_mcr(m)

## ----fig.width=7,fig.height=4.4-----------------------------------------------
graph(stat_mcr(m))

## ----fig.width=7,fig.height=4.4-----------------------------------------------
graph(stat_mcr(m),dif=FALSE)

## ----fig.width=7,fig.height=4.4-----------------------------------------------
graph(stat_tcs(m),dif=FALSE)


## ----fig.width=7,fig.height=4.4-----------------------------------------------
graph(stat_ecs(m),dif=FALSE)


