% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{mx}
\alias{mx}
\alias{\%mx\%}
\title{Numerical and Symbolic Matrix Product}
\usage{
mx(x, y)

x \%mx\% y
}
\arguments{
\item{x}{\code{numeric} or \code{character} matrix.}

\item{y}{\code{numeric} or \code{character} matrix.}
}
\value{
\code{matrix}.
}
\description{
Multiplies two \code{numeric} or \code{character} matrices, if they are conformable. If one argument is a vector, it will be promoted to either a row or column matrix to make the two arguments conformable. If both are vectors of the same length, it will return the inner product (as a \code{matrix}).
}
\section{Functions}{
\itemize{
\item \code{\%mx\%}: binary operator.
}}

\examples{
### numeric inner product 
x <- 1:4
mx(x, x)

### symbolic inner product 
x <- letters[1:4]
mx(x, x)

### numeric matrix product
x <- letters[1:4]
y <- diag(4)
mx(x, y)

### symbolic matrix product
x <- array(1:12, dim = c(3,4))
y <- letters[1:4]
mx(x, y)

### binary operator
x <- array(1:12, dim = c(3,4))
y <- letters[1:4]
x \%mx\% y

}
\references{
Guidotti, E. (2020). "calculus: High dimensional numerical and symbolic calculus in R". \url{https://arxiv.org/abs/2101.00086}
}
\seealso{
Other matrix algebra: 
\code{\link{mxdet}()},
\code{\link{mxinv}()},
\code{\link{mxtr}()}
}
\concept{matrix algebra}
