#' Generalized Kronecker Delta
#' 
#' Computes the Generalized Kronecker Delta.
#' 
#' @param n number of elements for each dimension.
#' @param p order of the generalized Kronecker delta, \code{p=1} for the standard Kronecker delta.
#' 
#' @return array representing the generalized Kronecker delta tensor.
#' 
#' @examples
#' # Kronecker delta 3x3
#' kronecker(3)
#' 
#' # generalized Kronecker delta 3x3 of order 2 -> 3x3 x 3x3
#' kronecker(3, p = 2)  
#' 
#' @export
#'
kronecker <- function(n, p = 1){
  
  mu <- as.matrix(expand.grid(lapply(1:p, function(i) 1:n)))
  
  delta <- cpp_parity(mu, mu)
  
  return(array(delta, dim = rep(n,2*p)))
  
}